/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.raw;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.client.texture.RemoteTextureManager;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.entity.easynpc.raw.PiglinRaw;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.PiglinRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;

public class PiglinRawRenderer
extends PiglinRenderer {
    protected static final Map<PiglinRaw.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(PiglinRaw.Variant.class), map -> {
        map.put(PiglinRaw.Variant.PIGLIN, new ResourceLocation("textures/entity/piglin/piglin.png"));
        map.put(PiglinRaw.Variant.PIGLIN_BRUTE, new ResourceLocation("textures/entity/piglin/piglin_brute.png"));
        map.put(PiglinRaw.Variant.ZOMBIFIED_PIGLIN, new ResourceLocation("textures/entity/piglin/zombified_piglin.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)PiglinRaw.Variant.PIGLIN);

    public PiglinRawRenderer(EntityRendererProvider.Context context, ModelLayerLocation variantModelLocation, ModelLayerLocation innerArmorModelLocation, ModelLayerLocation outerArmorModelLocation, boolean isZombified) {
        super(context, variantModelLocation, innerArmorModelLocation, outerArmorModelLocation, isZombified);
    }

    public ResourceLocation m_5478_(Mob skeleton) {
        if (skeleton instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)skeleton;
            return this.getEntityTexture(easyNPC);
        }
        return super.m_5478_(skeleton);
    }

    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    public ResourceLocation getCustomTexture(SkinData<?> entity) {
        return CustomTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    public ResourceLocation getRemoteTexture(SkinData<?> entity) {
        return RemoteTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    public ResourceLocation getTextureByVariant(Enum<?> variant) {
        return TEXTURE_BY_VARIANT != null ? TEXTURE_BY_VARIANT.getOrDefault(variant, DEFAULT_TEXTURE) : Constants.BLANK_ENTITY_TEXTURE;
    }

    public <N extends EasyNPC<?>> ResourceLocation getEntityTexture(N easyNPC) {
        SkinData skinData = easyNPC.getEasyNPCSkinData();
        return switch (skinData.getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> this.getCustomTexture(skinData);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> this.getRemoteTexture(skinData);
            default -> this.getTextureByVariant(easyNPC.getEasyNPCVariantData().getVariant());
        };
    }
}

