/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.manager;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RendererManager {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String LOG_PREFIX = "[Renderer Manager]";
    private static final Map<EntityType<? extends Entity>, EntityRenderer<? extends Entity>> entityRendererMap = new HashMap<EntityType<? extends Entity>, EntityRenderer<? extends Entity>>();
    private static final Map<EntityType<? extends Entity>, LivingEntityRenderer<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>>> livingEntityRendererMap = new HashMap<EntityType<? extends Entity>, LivingEntityRenderer<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>>>();

    private RendererManager() {
    }

    public static LivingEntityRenderer<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> getLivingEntityRenderer(EntityType<? extends Entity> entityType, PathfinderMob pathfinderMob) {
        if (entityType == null || pathfinderMob == null) {
            return null;
        }
        LivingEntityRenderer<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> livingEntityRenderer = livingEntityRendererMap.get(entityType);
        if (livingEntityRenderer != null) {
            return livingEntityRenderer;
        }
        RendererManager.registerLivingEntityRenderer(entityType, pathfinderMob);
        return livingEntityRendererMap.get(entityType);
    }

    public static EntityRenderer<? extends Entity> getEntityRenderer(EntityType<?> entityType, PathfinderMob pathfinderMob) {
        if (entityType == null || pathfinderMob == null) {
            return null;
        }
        EntityRenderer<? extends Entity> entityRenderer = entityRendererMap.get(entityType);
        if (entityRenderer != null) {
            return entityRenderer;
        }
        RendererManager.registerEntityRenderer(entityType, pathfinderMob);
        return entityRendererMap.get(entityType);
    }

    public static LivingEntityRenderer<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> registerLivingEntityRenderer(EntityType<? extends Entity> entityType, PathfinderMob pathfinderMob) {
        if (entityType == null || pathfinderMob == null) {
            return null;
        }
        if (livingEntityRendererMap.containsKey(entityType)) {
            return livingEntityRendererMap.get(entityType);
        }
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        EntityRenderer entityRenderer = entityRenderDispatcher.m_114382_((Entity)pathfinderMob);
        if (entityRenderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)entityRenderer;
            log.debug("{} Registering living entity renderer {} for {}", (Object)LOG_PREFIX, (Object)livingEntityRenderer, entityType);
            livingEntityRendererMap.put(entityType, (LivingEntityRenderer<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>>)livingEntityRenderer);
            return livingEntityRenderer;
        }
        if (!entityRendererMap.containsKey(entityType)) {
            log.debug("{} Registering entity renderer {} for {}", (Object)LOG_PREFIX, (Object)entityRenderer, entityType);
            entityRendererMap.put(entityType, (EntityRenderer<? extends Entity>)entityRenderer);
        }
        return null;
    }

    public static EntityRenderer<? extends Entity> registerEntityRenderer(EntityType<? extends Entity> entityType, PathfinderMob pathfinderMob) {
        if (entityType == null || pathfinderMob == null) {
            return null;
        }
        if (entityRendererMap.containsKey(entityType)) {
            return entityRendererMap.get(entityType);
        }
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        EntityRenderer entityRenderer = entityRenderDispatcher.m_114382_((Entity)pathfinderMob);
        log.debug("{} Registering entity renderer {} for {}", (Object)LOG_PREFIX, (Object)entityRenderer, entityType);
        entityRendererMap.put(entityType, (EntityRenderer<? extends Entity>)entityRenderer);
        return entityRenderer;
    }

    public static void copyCustomEntityData(PathfinderMob sourceEntity, Entity targetEntity) {
        if (sourceEntity == null || targetEntity == null || sourceEntity == targetEntity) {
            return;
        }
        targetEntity.f_19797_ = sourceEntity.f_19797_;
        targetEntity.m_146922_(sourceEntity.m_146908_());
        targetEntity.f_19859_ = sourceEntity.f_19859_;
        targetEntity.m_146926_(sourceEntity.m_146909_());
        targetEntity.f_19860_ = sourceEntity.f_19860_;
        targetEntity.m_5616_(sourceEntity.m_6080_());
        targetEntity.m_5618_(sourceEntity.f_20883_);
        targetEntity.m_6034_(sourceEntity.m_20185_(), sourceEntity.m_20186_(), sourceEntity.m_20189_());
        targetEntity.m_6853_(sourceEntity.m_20096_());
        targetEntity.m_20256_(sourceEntity.m_20184_());
        if (sourceEntity.m_8077_()) {
            targetEntity.m_6593_(sourceEntity.m_7770_());
            targetEntity.m_20340_(sourceEntity.m_20151_());
        }
        if (sourceEntity.m_20089_() != targetEntity.m_20089_()) {
            targetEntity.m_20124_(sourceEntity.m_20089_());
        }
    }

    public static void copyCustomLivingEntityData(PathfinderMob sourceEntity, LivingEntity targetEntity) {
        if (sourceEntity == null || targetEntity == null || sourceEntity == targetEntity) {
            return;
        }
        RendererManager.copyCustomEntityData(sourceEntity, (Entity)targetEntity);
        targetEntity.f_20886_ = sourceEntity.f_20886_;
        targetEntity.f_20884_ = sourceEntity.f_20884_;
        targetEntity.f_20921_ = sourceEntity.f_20921_;
        targetEntity.f_20920_ = sourceEntity.f_20920_;
        targetEntity.f_20925_ = sourceEntity.f_20925_;
        targetEntity.f_20923_ = sourceEntity.f_20923_;
        targetEntity.f_20924_ = sourceEntity.f_20924_;
        if (!sourceEntity.m_21205_().m_41619_()) {
            targetEntity.m_21008_(InteractionHand.MAIN_HAND, sourceEntity.m_21205_());
        }
        if (!sourceEntity.m_21206_().m_41619_()) {
            targetEntity.m_21008_(InteractionHand.OFF_HAND, sourceEntity.m_21206_());
        }
    }
}

