/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.Graphics;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class Checkbox
extends AbstractButton {
    private static final ResourceLocation TEXTURE = new ResourceLocation("easy_npc", "textures/gui/checkbox.png");
    protected final OnChange onChange;
    private final boolean showLabel;
    private final Font font;
    private boolean selected;

    public Checkbox(int left, int top, String label, boolean selected, OnChange onChange) {
        this(left, top, (Component)TextComponent.getTextComponent(label), selected, true, onChange);
    }

    public Checkbox(int left, int top, String label, Component data, boolean selected, OnChange onChange) {
        this(left, top, (Component)TextComponent.getTextComponent(label, data), selected, true, onChange);
    }

    public Checkbox(int left, int top, String label, String data, boolean selected, OnChange onChange) {
        this(left, top, (Component)TextComponent.getTextComponent(label, data), selected, true, onChange);
    }

    public Checkbox(int left, int top, String label, boolean selected) {
        this(left, top, (Component)TextComponent.getTranslatedText(label), selected, true);
    }

    public Checkbox(int left, int top, Component component, boolean selected, boolean showLabel) {
        this(left, top, component, selected, showLabel, null);
    }

    public Checkbox(int left, int top, Component component, boolean selected, boolean showLabel, OnChange onChange) {
        super(left, top, 16, 16, component);
        this.selected = selected;
        this.showLabel = showLabel;
        Minecraft minecraft = Minecraft.m_91087_();
        this.font = minecraft.f_91062_;
        this.onChange = onChange;
    }

    public void m_5691_() {
        boolean bl = this.selected = !this.selected;
        if (this.onChange != null) {
            this.onChange.onChange(this);
        }
    }

    public boolean selected() {
        return this.selected;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
        if (this.f_93623_) {
            if (this.m_93696_()) {
                narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)TextComponent.getTranslatedTextRaw("narration.checkbox.usage.focused"));
            } else {
                narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)TextComponent.getTranslatedTextRaw("narration.checkbox.usage.hovered"));
            }
        }
    }

    public void m_6303_(PoseStack poseStack, int left, int top, float partialTicks) {
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Graphics.blit(poseStack, TEXTURE, this.f_93620_, this.f_93621_, this.f_93623_ ? (this.m_198029_() ? 16 : 0) : 32, this.selected ? 16 : 0, 16, 16, 64, 64);
        if (this.showLabel) {
            Text.drawString(poseStack, this.font, this.m_6035_(), this.f_93620_ + 18, Math.round((float)this.f_93621_ + (float)(this.f_93619_ - 8) / 2.0f));
        }
    }

    public static interface OnChange {
        public void onChange(Checkbox var1);
    }
}

