/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.texture.TextureManager;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.io.RemoteSkinDataFiles;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemoteTextureManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final HashMap<TextureModelKey, ResourceLocation> textureCache = new HashMap();
    private static final HashMap<TextureModelKey, SkinType> textureSkinTypeCache = new HashMap();
    private static final HashMap<TextureModelKey, String> textureSkinURLCache = new HashMap();
    private static final HashSet<UUID> textureReloadProtection = new HashSet();
    private static final String LOG_PREFIX = "[Remote Texture Manager] ";

    private RemoteTextureManager() {
    }

    public static Set<UUID> getTextureCacheKeys(SkinModel skinModel) {
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (TextureModelKey textureModelKey : textureCache.keySet()) {
            if (!skinModel.equals((Object)textureModelKey.getSkinModel()) || !RemoteTextureManager.hasTextureSkinData(textureModelKey)) continue;
            hashSet.add(textureModelKey.getUUID());
        }
        return hashSet;
    }

    public static String getTextureSkinURL(TextureModelKey textureModelKey) {
        return textureSkinURLCache.get(textureModelKey);
    }

    public static SkinType getTextureSkinType(TextureModelKey textureModelKey) {
        return textureSkinTypeCache.get(textureModelKey);
    }

    public static boolean hasTextureSkinData(TextureModelKey textureModelKey) {
        return textureSkinTypeCache.containsKey(textureModelKey) && textureSkinURLCache.containsKey(textureModelKey);
    }

    public static ResourceLocation getOrCreateTextureWithDefault(SkinData<?> skinData, ResourceLocation defaultResourceLocation) {
        UUID skinUUID = skinData.getSkinUUID();
        if (skinUUID.equals(Constants.BLANK_UUID)) {
            return defaultResourceLocation;
        }
        TextureModelKey textureModelKey = new TextureModelKey(skinUUID, skinData.getSkinModel());
        ResourceLocation resourceLocation = textureCache.get(textureModelKey);
        String skinURL = skinData.getSkinURL();
        if (resourceLocation != null) {
            if (!RemoteTextureManager.hasTextureSkinData(textureModelKey)) {
                textureSkinTypeCache.put(textureModelKey, skinData.getSkinType());
                textureSkinURLCache.put(textureModelKey, skinURL);
            }
            return resourceLocation;
        }
        ResourceLocation createdResourceLocation = RemoteTextureManager.createTexture(textureModelKey, skinData, skinURL);
        return createdResourceLocation != null ? createdResourceLocation : defaultResourceLocation;
    }

    private static ResourceLocation createTexture(TextureModelKey textureModelKey, SkinData<?> skinData, String skinURL) {
        UUID skinUUID = textureModelKey.getUUID();
        if (!textureReloadProtection.add(skinUUID)) {
            return null;
        }
        SkinModel skinModel = skinData.getSkinModel();
        Path textureDataFolder = RemoteSkinDataFiles.getRemoteSkinDataFolder(skinModel);
        if (textureDataFolder == null) {
            return null;
        }
        ResourceLocation localTextureCache = TextureManager.getCachedTexture(textureModelKey, textureDataFolder);
        if (localTextureCache != null) {
            textureCache.put(textureModelKey, localTextureCache);
            textureSkinTypeCache.put(textureModelKey, skinData.getSkinType());
            textureSkinURLCache.put(textureModelKey, skinURL);
            return localTextureCache;
        }
        ResourceLocation resourceLocation = TextureManager.addRemoteTexture(textureModelKey, skinURL, textureDataFolder);
        if (resourceLocation != null) {
            textureCache.put(textureModelKey, resourceLocation);
            textureSkinTypeCache.put(textureModelKey, skinData.getSkinType());
            textureSkinURLCache.put(textureModelKey, skinURL);
            return resourceLocation;
        }
        log.error("{} Unable to load remote texture {} ({}) from {}!", (Object)LOG_PREFIX, (Object)textureModelKey, (Object)skinURL, (Object)textureDataFolder);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.m_6352_((Component)TextComponent.getText("[Remote Texture Manager] Unable to load remote " + skinURL + " texture " + String.valueOf(textureModelKey)).m_130940_(ChatFormatting.RED), Util.f_137441_);
        }
        return null;
    }

    public static void registerTexture(SkinModel skinModel, File textureFile) {
        RemoteTextureManager.registerTexture(TextureManager.getTextureModelKey(skinModel, textureFile), textureFile);
    }

    public static void registerTexture(TextureModelKey textureModelKey, File textureFile) {
        ResourceLocation resourceLocation = TextureManager.addCustomTexture(textureModelKey, textureFile);
        if (resourceLocation != null) {
            textureCache.put(textureModelKey, resourceLocation);
        }
    }
}

