/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.render;

import de.markusbordihn.easynpc.data.render.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RenderDataSet {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String DATA_RENDER_TYPE_TAG = "Type";
    private static final String DATA_RENDER_ENTITY_TYPE_TAG = "EntityType";
    private EntityType<?> renderEntityType = null;
    private RenderType renderType = RenderType.DEFAULT;

    public RenderDataSet() {
    }

    public RenderDataSet(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public void setRenderType(RenderType renderType) {
        this.renderType = renderType;
    }

    public EntityType<? extends Entity> getRenderEntityType() {
        return this.renderEntityType;
    }

    public void setRenderEntityType(EntityType<? extends Entity> renderEntityType) {
        this.renderEntityType = renderEntityType;
        this.renderType = this.renderEntityType != null ? RenderType.CUSTOM_ENTITY : RenderType.DEFAULT;
    }

    public void load(CompoundTag compoundTag) {
        this.renderType = compoundTag.m_128441_(DATA_RENDER_TYPE_TAG) ? RenderType.get(compoundTag.m_128461_(DATA_RENDER_TYPE_TAG)) : RenderType.DEFAULT;
        this.renderEntityType = compoundTag.m_128441_(DATA_RENDER_ENTITY_TYPE_TAG) ? (EntityType)EntityType.m_20632_((String)compoundTag.m_128461_(DATA_RENDER_ENTITY_TYPE_TAG)).orElse(null) : null;
    }

    public CompoundTag save(CompoundTag compoundTag) {
        if (this.renderType != RenderType.DEFAULT) {
            compoundTag.m_128359_(DATA_RENDER_TYPE_TAG, this.renderType.name());
        }
        if (this.renderEntityType != null && this.renderEntityType.m_20584_()) {
            ResourceLocation entityTypeResourceLocation = EntityType.m_20613_(this.renderEntityType);
            compoundTag.m_128359_(DATA_RENDER_ENTITY_TYPE_TAG, entityTypeResourceLocation.toString());
        }
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.save(new CompoundTag());
    }
}

