/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelArmPose;
import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelPositionData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelRotationData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelVisibilityData;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;

public interface ModelData<T extends PathfinderMob>
extends EasyNPC<T>,
ModelPositionData<T>,
ModelRotationData<T>,
ModelVisibilityData<T> {
    public static final CustomScale DEFAULT_MODEL_PART_SCALE = new CustomScale(1.0f, 1.0f, 1.0f);
    public static final String EASY_NPC_DATA_MODEL_DATA_TAG = "ModelData";
    public static final String EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG = "DefaultPose";
    public static final String EASY_NPC_DATA_MODEL_POSE_TAG = "Pose";
    public static final String EASY_NPC_DATA_MODEL_SCALE_TAG = "Scale";
    public static final String EASY_NPC_DATA_MODEL_SMART_ANIMATIONS_TAG = "SmartAnimations";

    public static void registerSyncedModelData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Model Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.MODEL_POSE, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.MODEL_POSE));
        map.put(SynchedDataIndex.MODEL_HEAD_SCALE, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.SCALE));
        map.put(SynchedDataIndex.MODEL_BODY_SCALE, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.SCALE));
        map.put(SynchedDataIndex.MODEL_ARMS_SCALE, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.SCALE));
        map.put(SynchedDataIndex.MODEL_LEFT_ARM_SCALE, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.SCALE));
        map.put(SynchedDataIndex.MODEL_RIGHT_ARM_SCALE, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.SCALE));
        map.put(SynchedDataIndex.MODEL_LEFT_LEG_SCALE, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.SCALE));
        map.put(SynchedDataIndex.MODEL_RIGHT_LEG_SCALE, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.SCALE));
        map.put(SynchedDataIndex.ITEM_SMART_ANIMATIONS, SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135035_));
        map.put(SynchedDataIndex.MODEL_SMART_ANIMATIONS, SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135035_));
        ModelPositionData.registerSyncedModelPositionData(map, entityClass);
        ModelRotationData.registerSyncedModelRotationData(map, entityClass);
        ModelVisibilityData.registerSyncedModelVisibilityData(map, entityClass);
    }

    default public Pose getDefaultPose() {
        return this.getEntity().m_20089_();
    }

    default public void setDefaultPose(Pose pose) {
        this.getEntity().m_20124_(pose);
    }

    default public ModelPose getModelPose() {
        return (ModelPose)((Object)this.getSynchedEntityData(SynchedDataIndex.MODEL_POSE));
    }

    default public void setModelPose(ModelPose modelPose) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_POSE, modelPose);
    }

    default public CustomScale getModelPartScale(ModelPart modelPart) {
        return switch (modelPart) {
            case ModelPart.HEAD -> this.getModelHeadScale();
            case ModelPart.BODY -> this.getModelBodyScale();
            case ModelPart.ARMS -> this.getModelArmsScale();
            case ModelPart.LEFT_ARM -> this.getModelLeftArmScale();
            case ModelPart.RIGHT_ARM -> this.getModelRightArmScale();
            case ModelPart.LEFT_LEG -> this.getModelLeftLegScale();
            case ModelPart.RIGHT_LEG -> this.getModelRightLegScale();
            default -> DEFAULT_MODEL_PART_SCALE;
        };
    }

    default public CustomScale getModelHeadScale() {
        return (CustomScale)this.getSynchedEntityData(SynchedDataIndex.MODEL_HEAD_SCALE);
    }

    default public void setModelHeadScale(CustomScale modelHeadScale) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_HEAD_SCALE, modelHeadScale);
    }

    default public CustomScale getModelBodyScale() {
        return (CustomScale)this.getSynchedEntityData(SynchedDataIndex.MODEL_BODY_SCALE);
    }

    default public void setModelBodyScale(CustomScale modelBodyScale) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_BODY_SCALE, modelBodyScale);
    }

    default public CustomScale getModelArmsScale() {
        return (CustomScale)this.getSynchedEntityData(SynchedDataIndex.MODEL_ARMS_SCALE);
    }

    default public void setModelArmsScale(CustomScale modelArmsScale) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_ARMS_SCALE, modelArmsScale);
    }

    default public CustomScale getModelLeftArmScale() {
        return (CustomScale)this.getSynchedEntityData(SynchedDataIndex.MODEL_LEFT_ARM_SCALE);
    }

    default public void setModelLeftArmScale(CustomScale modelLeftArmScale) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_LEFT_ARM_SCALE, modelLeftArmScale);
    }

    default public CustomScale getModelRightArmScale() {
        return (CustomScale)this.getSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_ARM_SCALE);
    }

    default public void setModelRightArmScale(CustomScale modelRightArmScale) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_ARM_SCALE, modelRightArmScale);
    }

    default public CustomScale getModelLeftLegScale() {
        return (CustomScale)this.getSynchedEntityData(SynchedDataIndex.MODEL_LEFT_LEG_SCALE);
    }

    default public void setModelLeftLegScale(CustomScale modelLeftLegScale) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_LEFT_LEG_SCALE, modelLeftLegScale);
    }

    default public CustomScale getModelRightLegScale() {
        return (CustomScale)this.getSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_LEG_SCALE);
    }

    default public void setModelRightLegScale(CustomScale modelRightLegScale) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_LEG_SCALE, modelRightLegScale);
    }

    default public boolean useSmartAnimations() {
        return this.supportsSmartAnimations() && this.getModelSupportsSmartAnimations() && this.getItemSupportsSmartAnimations();
    }

    default public boolean getModelSupportsSmartAnimations() {
        return this.getSynchedEntityData(SynchedDataIndex.MODEL_SMART_ANIMATIONS) != null && this.getSynchedEntityData(SynchedDataIndex.MODEL_SMART_ANIMATIONS).equals(true);
    }

    default public void setModelSupportsSmartAnimations(boolean useSmartAnimations) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_SMART_ANIMATIONS, useSmartAnimations);
    }

    default public boolean getItemSupportsSmartAnimations() {
        return this.getSynchedEntityData(SynchedDataIndex.ITEM_SMART_ANIMATIONS) != null && this.getSynchedEntityData(SynchedDataIndex.ITEM_SMART_ANIMATIONS).equals(true);
    }

    default public void setItemSupportsSmartAnimations(boolean useItemSmartAnimations) {
        this.setSynchedEntityData(SynchedDataIndex.ITEM_SMART_ANIMATIONS, useItemSmartAnimations);
    }

    default public boolean supportsSmartAnimations() {
        return true;
    }

    default public ModelArmPose getModelArmPose() {
        return this.getModelArmPose(this.getLivingEntity());
    }

    default public ModelArmPose getModelArmPose(LivingEntity livingEntity) {
        Mob mob;
        boolean isAggressive = livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5912_();
        ItemStack itemStack = livingEntity.m_21205_();
        if (isAggressive && AttackHandler.isBowWeapon(itemStack)) {
            return ModelArmPose.BOW_AND_ARROW;
        }
        AttackData attackData = this.getEasyNPCAttackData();
        if (AttackHandler.isCrossbowWeapon(itemStack)) {
            if (attackData.m_34773_()) {
                return ModelArmPose.CROSSBOW_CHARGE;
            }
            if (isAggressive) {
                return ModelArmPose.CROSSBOW_HOLD;
            }
        }
        if (isAggressive && AttackHandler.isGunWeapon(itemStack)) {
            return ModelArmPose.GUN_HOLD;
        }
        if (isAggressive && AttackHandler.isMeeleeWeapon(itemStack)) {
            return ModelArmPose.ATTACKING_WITH_MELEE_WEAPON;
        }
        return isAggressive ? ModelArmPose.ATTACKING : ModelArmPose.NEUTRAL;
    }

    @Override
    default public boolean hasHeadModelPart() {
        return true;
    }

    @Override
    default public boolean hasBodyModelPart() {
        return true;
    }

    @Override
    default public boolean hasArmsModelPart() {
        return false;
    }

    @Override
    default public boolean hasLeftArmModelPart() {
        return true;
    }

    @Override
    default public boolean hasRightArmModelPart() {
        return true;
    }

    @Override
    default public boolean hasLeftLegModelPart() {
        return true;
    }

    @Override
    default public boolean hasRightLegModelPart() {
        return true;
    }

    @Override
    default public boolean canUseArmor() {
        return true;
    }

    default public boolean canUseMainHand() {
        return true;
    }

    default public boolean canUseOffHand() {
        return true;
    }

    default public boolean hasChangedModel() {
        return this.hasChangedModelPosition() || this.hasChangedModelRotation() || this.hasChangedModelScale() || this.hasChangedModelVisibility();
    }

    default public boolean hasChangedModelScale() {
        return this.hasHeadModelPart() && this.getModelHeadScale().hasChanged() || this.hasBodyModelPart() && this.getModelBodyScale().hasChanged() || this.hasArmsModelPart() && this.getModelArmsScale().hasChanged() || this.hasLeftArmModelPart() && this.getModelLeftArmScale().hasChanged() || this.hasRightArmModelPart() && this.getModelRightArmScale().hasChanged() || this.hasLeftLegModelPart() && this.getModelLeftLegScale().hasChanged() || this.hasRightLegModelPart() && this.getModelRightLegScale().hasChanged();
    }

    default public void defineSynchedModelData() {
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_POSE, ModelPose.DEFAULT);
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_SMART_ANIMATIONS, true);
        this.defineSynchedEntityData(SynchedDataIndex.ITEM_SMART_ANIMATIONS, true);
        this.defineSynchedModelPositionData();
        this.defineSynchedModelRotationData();
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_HEAD_SCALE, new CustomScale(1.0f, 1.0f, 1.0f));
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_BODY_SCALE, new CustomScale(1.0f, 1.0f, 1.0f));
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_ARMS_SCALE, new CustomScale(1.0f, 1.0f, 1.0f));
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_LEFT_ARM_SCALE, new CustomScale(1.0f, 1.0f, 1.0f));
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_ARM_SCALE, new CustomScale(1.0f, 1.0f, 1.0f));
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_LEFT_LEG_SCALE, new CustomScale(1.0f, 1.0f, 1.0f));
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_LEG_SCALE, new CustomScale(1.0f, 1.0f, 1.0f));
        this.defineSynchedModelVisibilityData();
    }

    default public void addAdditionalModelData(CompoundTag compoundTag) {
        CompoundTag modelDataTag = new CompoundTag();
        if (this.getModelPose() != ModelPose.DEFAULT && this.hasChangedModel()) {
            modelDataTag.m_128359_(EASY_NPC_DATA_MODEL_POSE_TAG, this.getModelPose().name());
            modelDataTag.m_128359_(EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG, Pose.STANDING.name());
        } else {
            modelDataTag.m_128359_(EASY_NPC_DATA_MODEL_POSE_TAG, ModelPose.DEFAULT.name());
            modelDataTag.m_128359_(EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG, this.getDefaultPose() != null ? this.getDefaultPose().name() : Pose.STANDING.name());
        }
        this.addAdditionalModelPositionData(modelDataTag);
        this.addAdditionalModelRotationData(modelDataTag);
        this.addAdditionalModelVisibilityData(modelDataTag);
        modelDataTag.m_128379_(EASY_NPC_DATA_MODEL_SMART_ANIMATIONS_TAG, this.useSmartAnimations());
        compoundTag.m_128365_(EASY_NPC_DATA_MODEL_DATA_TAG, (Tag)modelDataTag);
    }

    default public void readAdditionalModelData(CompoundTag compoundTag) {
        String defaultPose;
        String modelPose;
        if (!compoundTag.m_128441_(EASY_NPC_DATA_MODEL_DATA_TAG)) {
            return;
        }
        CompoundTag modelDataTag = compoundTag.m_128469_(EASY_NPC_DATA_MODEL_DATA_TAG);
        if (modelDataTag.m_128441_(EASY_NPC_DATA_MODEL_POSE_TAG) && !(modelPose = modelDataTag.m_128461_(EASY_NPC_DATA_MODEL_POSE_TAG)).isEmpty()) {
            this.setModelPose(ModelPose.get(modelPose));
        }
        if (this.getModelPose() == ModelPose.DEFAULT && modelDataTag.m_128441_(EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG) && !(defaultPose = modelDataTag.m_128461_(EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG)).isEmpty()) {
            this.setDefaultPose(Pose.valueOf((String)defaultPose));
        }
        this.readAdditionalModelPositionData(modelDataTag);
        this.readAdditionalModelRotationData(modelDataTag);
        this.readAdditionalModelVisibilityData(modelDataTag);
        if (modelDataTag.m_128441_(EASY_NPC_DATA_MODEL_SMART_ANIMATIONS_TAG)) {
            this.setModelSupportsSmartAnimations(modelDataTag.m_128471_(EASY_NPC_DATA_MODEL_SMART_ANIMATIONS_TAG));
        }
    }
}

