/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.server.ServerDataAccessor;
import de.markusbordihn.easynpc.data.server.ServerDataIndex;
import de.markusbordihn.easynpc.data.server.ServerEntityData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;

public interface PresetData<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final ServerDataAccessor<UUID> CUSTOM_DATA_PRESET_UUID = ServerEntityData.defineId(ServerDataIndex.PRESET_UUID, EntityDataSerializersManager.UUID);
    public static final String PRESET_UUID_TAG = "PresetUUID";
    public static final String MOTION_TAG = "Motion";

    default public void importPresetData(CompoundTag compoundTag) {
        if (compoundTag == null || compoundTag.m_128456_() || this.getEntity() == null) {
            return;
        }
        if (this.getEntity() != null) {
            this.getEntity().m_20124_(Pose.STANDING);
        }
        if (this.getEasyNPCModelData() != null) {
            this.getEasyNPCModelData().setModelPose(ModelPose.DEFAULT);
        }
        if (this.getEasyNPCActionEventData() != null) {
            this.getEasyNPCActionEventData().clearActionEventSet();
        }
        if (this.getEasyNPCDialogData() != null) {
            this.getEasyNPCDialogData().clearDialogDataSet();
        }
        if (!compoundTag.m_128441_("UUID") || !compoundTag.m_128441_("Pos")) {
            CompoundTag existingCompoundTag = this.serializePresetData();
            if (existingCompoundTag.m_128441_("DialogData")) {
                existingCompoundTag.m_128473_("DialogData");
            }
            if (existingCompoundTag.m_128441_("ModelData")) {
                existingCompoundTag.m_128473_("ModelData");
            }
            if (existingCompoundTag.m_128441_("SkinData")) {
                existingCompoundTag.m_128473_("SkinData");
            }
            if (existingCompoundTag.m_128441_("RenderData")) {
                existingCompoundTag.m_128473_("RenderData");
            }
            if (existingCompoundTag.m_128441_("ActionData")) {
                existingCompoundTag.m_128473_("ActionData");
            }
            log.debug("Merging preset {} with existing data {} for {}", (Object)compoundTag, (Object)existingCompoundTag, (Object)this);
            compoundTag = existingCompoundTag.m_128391_(compoundTag);
        } else {
            log.debug("Importing full preset {} for {}", (Object)compoundTag, (Object)this);
        }
        this.getEntity().m_20258_(compoundTag);
    }

    default public CompoundTag serializePresetData() {
        CompoundTag entityData;
        CompoundTag compoundTag = new CompoundTag();
        if (this.getEntity() == null) {
            return compoundTag;
        }
        String entityTypeId = this.getEntityTypeId();
        if (entityTypeId != null) {
            compoundTag.m_128359_("id", entityTypeId);
        }
        if (!compoundTag.m_128441_(PRESET_UUID_TAG)) {
            compoundTag.m_128362_(PRESET_UUID_TAG, UUID.randomUUID());
        }
        if ((entityData = this.getEntity().m_20240_(compoundTag)).m_128441_(MOTION_TAG)) {
            entityData.m_128473_(MOTION_TAG);
        }
        return entityData;
    }

    default public boolean hasPresetUUID() {
        return this.getPresetUUID() != null;
    }

    default public UUID getPresetUUID() {
        return this.getEasyNPCServerData().getServerEntityData(CUSTOM_DATA_PRESET_UUID);
    }

    default public void setPresetUUID(UUID uuid) {
        this.getEasyNPCServerData().setServerEntityData(CUSTOM_DATA_PRESET_UUID, uuid);
    }

    default public void defineCustomPresetData() {
        this.getEasyNPCServerData().defineServerEntityData(CUSTOM_DATA_PRESET_UUID, null);
    }

    default public void addAdditionalPresetData(CompoundTag compoundTag) {
        if (this.isServerSideInstance() && this.getPresetUUID() != null) {
            compoundTag.m_128362_(PRESET_UUID_TAG, this.getPresetUUID());
        }
    }

    default public void readAdditionalPresetData(CompoundTag compoundTag) {
        if (compoundTag.m_128403_(PRESET_UUID_TAG)) {
            this.setPresetUUID(compoundTag.m_128342_(PRESET_UUID_TAG));
        }
    }
}

