/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.EasyNPCBaseEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class Illager
extends EasyNPCBaseEntity<Illager> {
    public static final String ID_EVOKER = "evoker";
    public static final String ID_ILLUSIONER = "illusioner";
    public static final String ID_PILLAGER = "pillager";
    public static final String ID_VINDICATOR = "vindicator";

    public Illager(EntityType<? extends PathfinderMob> entityType, Level level, Enum<?> variant) {
        super(entityType, level, variant);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22279_, (double)0.6f).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22283_, 0.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22285_, 0.0);
    }

    @Override
    public boolean canUseArmor() {
        return false;
    }

    @Override
    public boolean hasArmsModelPart() {
        return true;
    }

    @Override
    public SkinModel getSkinModel() {
        return SkinModel.ILLAGER;
    }

    @Override
    public Enum<?>[] getVariants() {
        return Variant.values();
    }

    @Override
    public Enum<?> getDefaultVariant() {
        return Variant.PILLAGER;
    }

    @Override
    public Enum<?> getVariant(String name) {
        try {
            return Variant.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return this.getDefaultVariant();
        }
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        Variant soundVariant = Variant.valueOf(variantName);
        switch (soundVariant) {
            case EVOKER: 
            case EVOKER_CROSSED_ARMS: {
                soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.f_11861_);
                soundDataSet.addSound(SoundType.DEATH, SoundEvents.f_11864_);
                soundDataSet.addSound(SoundType.HURT, SoundEvents.f_11866_);
                soundDataSet.addSound(SoundType.CAST_SPELL, SoundEvents.f_11862_);
                soundDataSet.addSound(SoundType.CELEBRATE, SoundEvents.f_11863_);
                break;
            }
            case ILLUSIONER: 
            case ILLUSIONER_CROSSED_ARMS: {
                soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.f_12048_);
                soundDataSet.addSound(SoundType.DEATH, SoundEvents.f_12050_);
                soundDataSet.addSound(SoundType.HURT, SoundEvents.f_12051_);
                soundDataSet.addSound(SoundType.CAST_SPELL, SoundEvents.f_12049_);
                soundDataSet.addSound(SoundType.CELEBRATE, SoundEvents.f_12308_);
                break;
            }
            case VINDICATOR: 
            case VINDICATOR_CROSSED_ARMS: {
                soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.f_12576_);
                soundDataSet.addSound(SoundType.DEATH, SoundEvents.f_12578_);
                soundDataSet.addSound(SoundType.HURT, SoundEvents.f_12579_);
                soundDataSet.addSound(SoundType.CELEBRATE, SoundEvents.f_12577_);
                break;
            }
            default: {
                soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.f_12307_);
                soundDataSet.addSound(SoundType.DEATH, SoundEvents.f_12309_);
                soundDataSet.addSound(SoundType.HURT, SoundEvents.f_12310_);
                soundDataSet.addSound(SoundType.CELEBRATE, SoundEvents.f_12308_);
            }
        }
        soundDataSet.addSound(SoundType.TRADE, SoundEvents.f_12508_);
        soundDataSet.addSound(SoundType.TRADE_YES, SoundEvents.f_12509_);
        soundDataSet.addSound(SoundType.TRADE_NO, SoundEvents.f_12507_);
        return soundDataSet;
    }

    public MobType m_6336_() {
        return MobType.f_21643_;
    }

    public static enum Variant {
        EVOKER,
        EVOKER_CROSSED_ARMS,
        ILLUSIONER,
        ILLUSIONER_CROSSED_ARMS,
        PILLAGER,
        VINDICATOR,
        VINDICATOR_CROSSED_ARMS;

    }
}

