/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.raw;

import de.markusbordihn.easynpc.data.server.ServerEntityData;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.data.synched.SynchedEntityData;
import de.markusbordihn.easynpc.data.ticker.TickerType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPCBase;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import de.markusbordihn.easynpc.entity.easynpc.handlers.InteractionHandler;
import de.markusbordihn.easynpc.entity.easynpc.handlers.VisibilityHandler;
import de.markusbordihn.easynpc.server.player.FakePlayer;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.EnumMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SkeletonRaw
extends Skeleton
implements EasyNPCBase<Skeleton> {
    public static final String ID = "skeleton_raw";
    protected static final EnumMap<SynchedDataIndex, EntityDataAccessor<?>> entityDataAccessorMap = new EnumMap(SynchedDataIndex.class);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private final EnumMap<TickerType, Integer> tickerMap = new EnumMap(TickerType.class);
    protected MerchantOffers merchantTradingOffers;
    private ServerEntityData serverEntityData;
    private int attackAnimationTick;
    private int npcDataVersion = -1;
    private UUID persistentAngerTarget;
    private int remainingPersistentAngerTime;
    private SynchedEntityData synchedEntityData;
    private Player tradingPlayer;
    private FakePlayer fakePlayer;

    public SkeletonRaw(EntityType<? extends Skeleton> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public FakePlayer getFakePlayer(ServerLevel level, BlockPos blockPos) {
        if (FakePlayer.isInvalidFakePlayer(this.fakePlayer)) {
            this.fakePlayer = new FakePlayer(level, blockPos);
            return this.fakePlayer;
        }
        return this.fakePlayer.updatePosition(level, blockPos);
    }

    @Override
    public int getTicker(TickerType tickerType) {
        return this.tickerMap.getOrDefault((Object)tickerType, 0);
    }

    @Override
    public void setTicker(TickerType tickerType, int ticker) {
        this.tickerMap.put(tickerType, ticker);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    @Override
    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public boolean m_7327_(Entity entity) {
        this.attackAnimationTick = 10;
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        return super.m_7327_(entity);
    }

    public void m_7822_(byte flag) {
        super.m_7822_(flag);
        if (flag == 4) {
            this.attackAnimationTick = 10;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isClientSideInstance()) {
            this.m_21203_();
            if (this.attackAnimationTick > 0) {
                --this.attackAnimationTick;
            }
        } else {
            this.m_21666_((ServerLevel)this.f_19853_, true);
        }
    }

    @Override
    public Player m_7962_() {
        return this.tradingPlayer;
    }

    @Override
    public void m_7189_(Player player) {
        this.tradingPlayer = player;
    }

    public Component m_7755_() {
        Component component = this.m_7770_();
        return component != null ? TextUtils.removeAction(component) : this.m_5677_();
    }

    public boolean m_6469_(DamageSource damageSource, float damage) {
        this.handleHurtEvent(damageSource, damage);
        return super.m_6469_(damageSource, damage);
    }

    public void m_6667_(DamageSource damageSource) {
        this.handleDieEvent(damageSource);
        super.m_6667_(damageSource);
    }

    public Entity m_5489_(ServerLevel serverLevel) {
        this.handleChangeDimensionEvent(serverLevel);
        return super.m_5489_(serverLevel);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        return InteractionHandler.handleMobInteraction(this, player, hand);
    }

    public boolean m_183595_() {
        return this.isClientSideInstance();
    }

    public boolean m_20145_() {
        return VisibilityHandler.handleIsInvisible(this, super.m_20145_());
    }

    public boolean m_20177_(Player player) {
        return VisibilityHandler.handleIsInvisibleToPlayer(this, player, super.m_20177_(player));
    }

    @Override
    public MerchantOffers getMerchantTradingOffers() {
        return this.merchantTradingOffers;
    }

    @Override
    public void setMerchantTradingOffers(MerchantOffers merchantOffers) {
        this.merchantTradingOffers = merchantOffers;
    }

    @Override
    public int getNPCDataVersion() {
        return this.npcDataVersion;
    }

    @Override
    public void setNPCDataVersion(int version) {
        this.npcDataVersion = version;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficulty, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData, CompoundTag compoundTag) {
        return this.finalizeEasyNPCSpawn(super.m_6518_(serverLevelAccessor, difficulty, mobSpawnType, spawnGroupData, compoundTag));
    }

    @Override
    public void handleEasyNPCJoinEvent(EasyNPC<?> easyNPC) {
        this.onEasyNPCJoinUpdateObjective(easyNPC);
    }

    @Override
    public void handleEasyNPCLeaveEvent(EasyNPC<?> easyNPC) {
        this.onEasyNPCLeaveUpdateObjective(easyNPC);
    }

    @Override
    public void handlePlayerJoinEvent(ServerPlayer serverPlayer) {
        this.onPlayerJoinUpdateObjective(serverPlayer);
    }

    @Override
    public void handlePlayerLeaveEvent(ServerPlayer serverPlayer) {
        this.onPlayerLeaveUpdateObjective(serverPlayer);
    }

    @Override
    public void handleLivingEntityJoinEvent(LivingEntity livingEntity) {
        this.onLivingEntityJoinUpdateObjective(livingEntity);
    }

    @Override
    public void handleLivingEntityLeaveEvent(LivingEntity livingEntity) {
        this.onLivingEntityLeaveUpdateObjective(livingEntity);
    }

    public boolean m_5886_(ProjectileWeaponItem projectileWeaponItem) {
        return AttackHandler.canFireProjectileWeapon(projectileWeaponItem);
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int remainingPersistentAngerTime) {
        this.remainingPersistentAngerTime = remainingPersistentAngerTime;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(UUID targetUUID) {
        this.persistentAngerTarget = targetUUID;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_142270_(this.f_19796_));
    }

    @Override
    public GoalSelector getEntityGoalSelector() {
        return this.f_21345_;
    }

    @Override
    public GoalSelector getEntityTargetSelector() {
        return this.f_21346_;
    }

    @Override
    public <T> void defineSynchedEntityData(SynchedDataIndex synchedDataIndex, T defaultData) {
        if (this.synchedEntityData == null) {
            this.synchedEntityData = new SynchedEntityData((Entity)this, entityDataAccessorMap);
        }
        this.synchedEntityData.define(synchedDataIndex, defaultData);
    }

    @Override
    public <T> void setSynchedEntityData(SynchedDataIndex synchedDataIndex, T data) {
        this.synchedEntityData.set(synchedDataIndex, data);
    }

    @Override
    public <T> T getSynchedEntityData(SynchedDataIndex synchedDataIndex) {
        return this.synchedEntityData.get(synchedDataIndex);
    }

    @Override
    public void defineServerEntityData() {
        this.serverEntityData = new ServerEntityData((Entity)this);
    }

    @Override
    public ServerEntityData getServerEntityData() {
        if (this.serverEntityData == null) {
            this.defineServerEntityData();
        }
        return this.serverEntityData;
    }

    public boolean m_6573_(Player player) {
        ServerPlayer serverPlayer;
        if (!this.m_21523_() && player instanceof ServerPlayer && ((serverPlayer = (ServerPlayer)player).m_7500_() || this.isOwner(serverPlayer))) {
            return true;
        }
        return !this.m_21523_() && this.getEntityAttributes().getInteractionAttributes().canBeLeashed();
    }

    public boolean m_6040_() {
        return this.getEntityAttributes().getEnvironmentalAttributes().canBreatheUnderwater();
    }

    public boolean m_6097_() {
        return this.getEntityAttributes().getCombatAttributes().isAttackable();
    }

    public boolean m_6094_() {
        return this.getEntityAttributes().getInteractionAttributes().isPushable();
    }

    protected void m_6138_() {
        if (this.getEntityAttributes().getInteractionAttributes().pushEntities()) {
            super.m_6138_();
        }
    }

    public boolean m_20147_() {
        return !this.getEntityAttributes().getCombatAttributes().isAttackable();
    }

    public boolean m_6673_(DamageSource damageSource) {
        return this.m_20147_() || super.m_6673_(damageSource);
    }

    public void m_8032_() {
        this.playDefaultAmbientSound();
    }

    public int m_8100_() {
        return 240;
    }

    public void m_6677_(DamageSource damageSource) {
        this.playDefaultHurtSound(damageSource);
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.playDefaultStepSound(blockPos, blockState);
    }

    public SoundEvent m_5592_() {
        return this.getDefaultDeathSound();
    }

    protected void m_20157_() {
        if (this.getEntityAttributes().getMovementAttributes().canUseNetherPortal()) {
            super.m_20157_();
        }
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.isClientSideInstance() || !this.m_6084_()) {
            return;
        }
        this.handleCustomObjectiveBaseTick();
        this.handleBaseTick();
    }

    public void m_7023_(Vec3 vec3) {
        this.handleNavigationTravelEvent(vec3);
        super.m_7023_(vec3);
    }

    public boolean m_6741_() {
        return false;
    }

    public void m_5853_(SoundSource soundSource) {
        if (soundSource != null) {
            this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_12236_, soundSource, 0.5f, 1.0f);
        }
    }

    public boolean m_6254_() {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    @Override
    public boolean supportsPoseConfiguration() {
        return false;
    }

    @Override
    public boolean supportsScalingConfiguration() {
        return false;
    }

    @Override
    public boolean supportsDefaultRotationConfiguration() {
        return false;
    }

    @Override
    public boolean supportsChangeModelConfiguration() {
        return false;
    }

    @Override
    public SkinModel getSkinModel() {
        return SkinModel.SKELETON;
    }

    @Override
    public Enum<?>[] getVariants() {
        return Variant.values();
    }

    @Override
    public Enum<?> getDefaultVariant() {
        return Variant.SKELETON;
    }

    @Override
    public Enum<?> getVariant(String name) {
        try {
            return Variant.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return this.getDefaultVariant();
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.defineEasyNPCBaseSyncedData();
        this.defineEasyNPCBaseServerSideData();
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        this.m_21678_(compoundTag);
        this.addEasyNPCBaseAdditionalSaveData(compoundTag);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.m_147285_(this.f_19853_, compoundTag);
        this.readEasyNPCBaseAdditionalSaveData(compoundTag);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EasyNPCBase)) {
            return false;
        }
        EasyNPCBase easyNPCBase = (EasyNPCBase)object;
        return Objects.equals(this.m_142081_(), easyNPCBase.getEntityUUID());
    }

    public int hashCode() {
        return Objects.hash(this.m_142081_());
    }

    static {
        EasyNPCBase.registerEasyNPCSyncedData(entityDataAccessorMap, SkeletonRaw.class);
    }

    public static enum Variant {
        SKELETON,
        STRAY,
        WITHER_SKELETON;

    }
}

