/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.item.configuration;

import com.mojang.serialization.DynamicOps;
import de.markusbordihn.easynpc.access.AccessManager;
import de.markusbordihn.easynpc.block.entity.EasyNPCSpawnerBlockEntity;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.PresetData;
import de.markusbordihn.easynpc.item.configuration.EasyNPCPresetItem;
import de.markusbordihn.easynpc.level.BaseEasyNPCSpawner;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCPresetEmptyItem
extends Item {
    public static final String NAME = "easy_npc_preset_empty";
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String SPAWN_DATA_TAG = "SpawnData";
    private static final String ID_TAG = "id";

    public EasyNPCPresetEmptyItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        if (livingEntity instanceof Player) {
            return InteractionResult.FAIL;
        }
        Level level = livingEntity.m_183503_();
        if (livingEntity instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)livingEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!AccessManager.hasAccess(serverPlayer, easyNPC)) {
                    return InteractionResult.FAIL;
                }
                ItemStack presetItemStack = this.createPresetItemStack(easyNPC);
                if (!presetItemStack.m_41619_()) {
                    if (!player.m_150109_().m_36054_(presetItemStack)) {
                        player.m_36176_(presetItemStack, false);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private ItemStack createPresetItemStack(EasyNPC<?> easyNPC) {
        PresetData presetData = easyNPC.getEasyNPCPresetData();
        if (presetData == null) {
            log.error("Can't export preset data from {}", easyNPC);
            return ItemStack.f_41583_;
        }
        return this.createPresetItemStack(easyNPC.getLivingEntity().m_6095_(), presetData.serializePresetData());
    }

    private ItemStack createPresetItemStack(EntityType<?> entityType, CompoundTag compoundTag) {
        Item item = Registry.f_122827_.m_6612_(new ResourceLocation("easy_npc", "easy_npc_preset")).orElse(null);
        if (item == null) {
            log.error("Can't find item for storing preset {}", (Object)"easy_npc_preset");
            return ItemStack.f_41583_;
        }
        ResourceLocation entityTypeRegistryName = EntityType.m_20613_(entityType);
        ItemStack presetItemStack = new ItemStack((ItemLike)item);
        EasyNPCPresetItem.savePreset(presetItemStack, entityTypeRegistryName, compoundTag);
        log.debug("Captured NPC preset from {} with {} to {}", (Object)entityTypeRegistryName, (Object)compoundTag, (Object)presetItemStack);
        return presetItemStack;
    }

    public InteractionResult m_6225_(UseOnContext useOnContext) {
        ItemStack presetItemStack;
        ResourceLocation entityRegistryName;
        EntityType entityType;
        SpawnData spawnData;
        CompoundTag entitySpawnData;
        EasyNPCSpawnerBlockEntity spawnerBlockEntity;
        BaseEasyNPCSpawner baseSpawner;
        CompoundTag compoundTag;
        BlockEntity blockEntity;
        Level level = useOnContext.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos blockPos = useOnContext.m_8083_();
        BlockState blockState = level.m_8055_(blockPos);
        if (!blockState.m_60795_() && (blockEntity = level.m_7702_(blockPos)) instanceof EasyNPCSpawnerBlockEntity && (compoundTag = (baseSpawner = (spawnerBlockEntity = (EasyNPCSpawnerBlockEntity)blockEntity).getSpawner()).m_186381_(new CompoundTag())) != null && compoundTag.m_128441_(SPAWN_DATA_TAG) && (entitySpawnData = (spawnData = SpawnData.f_186559_.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128469_(SPAWN_DATA_TAG)).resultOrPartial(string -> log.warn("Invalid SpawnData: {}", string)).orElseGet(SpawnData::new)).m_186567_()).m_128441_(ID_TAG) && (entityType = (EntityType)Registry.f_122826_.m_7745_(entityRegistryName = new ResourceLocation(entitySpawnData.m_128461_(ID_TAG)))) != null && !(presetItemStack = this.createPresetItemStack(entityType, entitySpawnData.m_6426_())).m_41619_()) {
            Player player = useOnContext.m_43723_();
            if (!player.m_150109_().m_36054_(presetItemStack)) {
                player.m_36176_(presetItemStack, false);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_6777_(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        return false;
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        tooltipList.add((Component)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset_empty").m_130940_(ChatFormatting.RED));
    }
}

