/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.item.configuration;

import de.markusbordihn.easynpc.block.entity.EasyNPCSpawnerBlockEntity;
import de.markusbordihn.easynpc.level.BaseEasyNPCSpawner;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.SpawnerUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCPresetItem
extends Item {
    public static final String ENTITY_TYPE_TAG = "EntityType";
    public static final String NAME = "easy_npc_preset";
    public static final String PRESET_TAG = "Preset";
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String FALL_DISTANCE_TAG = "FallDistance";
    private static final String FIRE_TAG = "Fire";
    private static final String ON_GROUND_TAG = "OnGround";
    private static final String CUSTOM_NAME_TAG = "CustomName";
    private static final String TEXT_TAG = "text";

    public EasyNPCPresetItem(Item.Properties properties) {
        super(properties);
    }

    public static UUID getPresetUUID(ItemStack itemStack) {
        CompoundTag compoundTag = EasyNPCPresetItem.getPreset(itemStack);
        if (compoundTag.m_128441_("PresetUUID")) {
            return compoundTag.m_128342_("PresetUUID");
        }
        return null;
    }

    public static boolean hasPreset(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        return compoundTag.m_128441_(PRESET_TAG) && !compoundTag.m_128469_(PRESET_TAG).m_128456_();
    }

    public static CompoundTag getPreset(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        return compoundTag.m_128469_(PRESET_TAG);
    }

    public static void savePreset(ItemStack itemStack, ResourceLocation entityType, CompoundTag presetData) {
        CompoundTag compoundTag = itemStack.m_41784_();
        compoundTag.m_128359_(ENTITY_TYPE_TAG, entityType.toString());
        if (presetData.m_128441_(FIRE_TAG)) {
            presetData.m_128473_(FIRE_TAG);
        }
        if (presetData.m_128441_(FALL_DISTANCE_TAG)) {
            presetData.m_128473_(FALL_DISTANCE_TAG);
        }
        if (presetData.m_128441_(ON_GROUND_TAG)) {
            presetData.m_128473_(ON_GROUND_TAG);
        }
        compoundTag.m_128365_(PRESET_TAG, (Tag)presetData);
    }

    public static String getCustomName(ItemStack itemStack) {
        CompoundTag customNameTag;
        CompoundTag compoundTag = EasyNPCPresetItem.getPreset(itemStack);
        if (compoundTag.m_128441_(CUSTOM_NAME_TAG) && (customNameTag = compoundTag.m_128469_(CUSTOM_NAME_TAG)).m_128441_(TEXT_TAG)) {
            return customNameTag.m_128461_(TEXT_TAG);
        }
        return null;
    }

    public static boolean hasEntityType(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        return compoundTag.m_128441_(ENTITY_TYPE_TAG) && !compoundTag.m_128461_(ENTITY_TYPE_TAG).isEmpty();
    }

    public static EntityType<?> getEntityType(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_(ENTITY_TYPE_TAG)) {
            return EntityType.m_20632_((String)compoundTag.m_128461_(ENTITY_TYPE_TAG)).orElse(null);
        }
        return null;
    }

    public static boolean spawnAtPosition(BlockPos blockPos, ItemStack itemStack, Level level) {
        if (level.f_46443_ || !EasyNPCPresetItem.hasPreset(itemStack) || !EasyNPCPresetItem.hasEntityType(itemStack)) {
            return false;
        }
        CompoundTag entityPreset = EasyNPCPresetItem.getPreset(itemStack);
        EntityType<?> entityType = EasyNPCPresetItem.getEntityType(itemStack);
        if (entityType == null) {
            log.error("No valid entity type found in {}!", (Object)itemStack);
            return false;
        }
        Entity entity = entityType.m_20615_(level);
        if (entity == null) {
            log.error("Unable to create entity for {} in {}", entityType, (Object)level);
            return false;
        }
        if (entityPreset.m_128441_("UUID")) {
            entityPreset.m_128473_("UUID");
        }
        entity.m_20258_(entityPreset);
        entity.m_6027_((double)((float)blockPos.m_123341_() + 0.5f), (double)blockPos.m_123342_(), (double)((float)blockPos.m_123343_() + 0.5f));
        if (level.m_7967_(entity)) {
            UUID presetUUID = EasyNPCPresetItem.getPresetUUID(itemStack);
            log.debug("Spawned {} at {} with preset UUID {} and {} in {}", entityType, (Object)blockPos, (Object)presetUUID, (Object)entityPreset, (Object)level);
            return true;
        }
        return false;
    }

    public InteractionResult m_6225_(UseOnContext useOnContext) {
        Level level = useOnContext.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = useOnContext.m_43722_();
        if (itemStack.m_41619_() || !EasyNPCPresetItem.hasPreset(itemStack) || !EasyNPCPresetItem.hasEntityType(itemStack)) {
            log.warn("No valid preset found in {}!", (Object)itemStack);
            return InteractionResult.FAIL;
        }
        BlockPos blockPos = useOnContext.m_8083_();
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
            BaseSpawner baseSpawner = spawnerBlockEntity.m_59801_();
            SpawnData spawnData = new SpawnData(EasyNPCPresetItem.getPreset(itemStack), Optional.empty());
            log.debug("Set spawn data {} for spawner {} at {}", (Object)spawnData, (Object)spawnerBlockEntity, (Object)blockPos);
            if (!SpawnerUtils.setNextSpawnData(baseSpawner, (LevelAccessor)level, blockPos, spawnData)) {
                return InteractionResult.FAIL;
            }
            spawnerBlockEntity.m_6596_();
            itemStack.m_41774_(1);
            return InteractionResult.CONSUME;
        }
        if (blockEntity instanceof EasyNPCSpawnerBlockEntity) {
            EasyNPCSpawnerBlockEntity easyNPCSpawnerBlockEntity = (EasyNPCSpawnerBlockEntity)blockEntity;
            BaseEasyNPCSpawner baseEasyNPCSpawner = easyNPCSpawnerBlockEntity.getSpawner();
            SpawnData spawnData = new SpawnData(EasyNPCPresetItem.getPreset(itemStack), Optional.empty());
            log.debug("Set spawn data {} for base NPC spawner {} at {}", (Object)spawnData, (Object)easyNPCSpawnerBlockEntity, (Object)blockPos);
            baseEasyNPCSpawner.m_142667_(level, blockPos, spawnData);
            easyNPCSpawnerBlockEntity.m_6596_();
            itemStack.m_41774_(1);
            return InteractionResult.CONSUME;
        }
        Iterable possibleSpawnPositions = BlockPos.m_121935_((BlockPos)useOnContext.m_8083_(), (int)4, (Direction)Direction.NORTH, (Direction)Direction.EAST);
        for (BlockPos.MutableBlockPos possibleSpawnPosition : possibleSpawnPositions) {
            AABB aabb = new AABB((BlockPos)possibleSpawnPosition).m_82400_(0.1);
            BlockPos targetBlockPos = new BlockPos((double)((float)possibleSpawnPosition.m_123341_() + 0.5f), (double)((float)possibleSpawnPosition.m_123342_() + 1.0f), (double)((float)possibleSpawnPosition.m_123343_() + 0.5f));
            if (!level.m_8055_(targetBlockPos.m_7494_()).m_60795_() || !level.m_45976_(Entity.class, aabb).isEmpty() || !EasyNPCPresetItem.spawnAtPosition(targetBlockPos, itemStack, level)) continue;
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_6777_(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        return false;
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        if (EasyNPCPresetItem.hasPreset(itemStack)) {
            UUID presetUUID = EasyNPCPresetItem.getPresetUUID(itemStack);
            if (presetUUID != null) {
                tooltipList.add((Component)TextComponent.getText(presetUUID.toString()).m_130940_(ChatFormatting.GRAY));
            }
            tooltipList.add((Component)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset").m_130940_(ChatFormatting.GREEN));
            EntityType<?> entityType = EasyNPCPresetItem.getEntityType(itemStack);
            if (entityType != null) {
                String customName = EasyNPCPresetItem.getCustomName(itemStack);
                if (customName != null) {
                    tooltipList.add((Component)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset.custom_name", customName).m_130940_(ChatFormatting.GRAY));
                }
                tooltipList.add((Component)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset.entity_type", entityType.m_20676_()).m_130940_(ChatFormatting.GRAY));
            }
        }
    }
}

