/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu;

import de.markusbordihn.easynpc.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.ClientMenuManager;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCMenu
extends AbstractContainerMenu {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    protected final Level level;
    protected final Player player;
    protected final ScreenData screenData;
    protected final AdditionalScreenData additionalScreenData;
    protected final EasyNPC<?> easyNPC;

    public EasyNPCMenu(MenuType<?> menuType, int containerId, Inventory playerInventory) {
        this(menuType, containerId, playerInventory, new CompoundTag());
    }

    public EasyNPCMenu(MenuType<?> menuType, int containerId, Inventory playerInventory, CompoundTag data) {
        super(menuType, containerId);
        this.player = playerInventory.f_35978_;
        this.level = playerInventory.f_35978_.m_183503_();
        ScreenData screenData = this.screenData = this.level.m_5776_() ? ClientMenuManager.getScreenData() : ScreenData.decode(data);
        if (this.screenData == null) {
            log.error("Screen data is missing for menu {} with {}", menuType, (Object)data);
            this.additionalScreenData = null;
            this.easyNPC = null;
            return;
        }
        AdditionalScreenData additionalScreenData = this.additionalScreenData = this.level.m_5776_() ? ClientMenuManager.getAdditionalScreenData() : new AdditionalScreenData(this.screenData.additionalData());
        if (this.additionalScreenData == null) {
            log.warn("Additional screen data is missing  menu {} with {}", menuType, (Object)this.screenData);
        }
        EasyNPC<?> easyNPC = this.easyNPC = this.level.f_46443_ ? LivingEntityManager.getEasyNPCEntityByUUID(this.getNpcUUID()) : LivingEntityManager.getEasyNPCEntityByUUID(this.getNpcUUID(), (ServerPlayer)this.player);
        if (this.easyNPC == null) {
            log.error("EasyNPC entity with UUID {} is missing for menu {} with {}", (Object)this.getNpcUUID(), menuType, (Object)this.screenData);
        }
    }

    public ScreenData getScreenData() {
        return this.screenData;
    }

    public AdditionalScreenData getAdditionalScreenData() {
        return this.additionalScreenData;
    }

    public UUID getNpcUUID() {
        return this.screenData.uuid();
    }

    public int getPageIndex() {
        return this.screenData.pageIndex();
    }

    public EasyNPC<?> getEasyNPC() {
        return this.easyNPC;
    }

    public boolean m_6875_(Player player) {
        return player.m_6084_();
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = slot.m_7993_();
        if (itemStack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        return ItemStack.f_41583_;
    }
}

