/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.commands.arguments.EquipmentSlotArgument;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.EquipmentHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class EquipmentCommand
extends Command {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"equipment").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").requires(commandSourceStack -> commandSourceStack.m_6761_(0))).then(Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(Commands.m_82129_((String)"slot", (ArgumentType)EquipmentSlotArgument.slot()).then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_120960_()).executes(context -> EquipmentCommand.setItemSlot((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), EquipmentSlotArgument.getEquipmentSlot((CommandContext<CommandSourceStack>)context, "slot"), ItemArgument.m_120963_((CommandContext)context, (String)"item").m_120979_()))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(commandSourceStack -> commandSourceStack.m_6761_(0))).then(Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(Commands.m_82129_((String)"slot", (ArgumentType)EquipmentSlotArgument.slot()).executes(context -> EquipmentCommand.removeItemSlot((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), EquipmentSlotArgument.getEquipmentSlot((CommandContext<CommandSourceStack>)context, "slot"))))));
    }

    private static int setItemSlot(CommandSourceStack context, EasyNPC<?> easyNPC, EquipmentSlot equipmentSlot, Item item) {
        if (easyNPC == null || equipmentSlot == null || item == null) {
            return 0;
        }
        ItemStack itemStack = new ItemStack((ItemLike)item);
        if (!EquipmentHandler.setEquipmentSlotItem(easyNPC, equipmentSlot, itemStack)) {
            return EquipmentCommand.sendFailureMessage(context, String.valueOf(easyNPC) + " failed to set item stack " + String.valueOf(itemStack) + " for slot " + String.valueOf(equipmentSlot));
        }
        return EquipmentCommand.sendSuccessMessage(context, String.valueOf(easyNPC) + " set item stack" + String.valueOf(itemStack) + " for slot " + String.valueOf(equipmentSlot));
    }

    private static int removeItemSlot(CommandSourceStack context, EasyNPC<?> easyNPC, EquipmentSlot equipmentSlot) {
        return EquipmentCommand.setItemSlot(context, easyNPC, equipmentSlot, Items.f_41852_);
    }
}

