/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationData;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;

public class NavigationCommand
extends Command {
    private static final String ARG_POSITION = "position";

    private NavigationCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"navigation").requires(cs -> cs.m_6761_(0))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"home").requires(commandSourceStack -> commandSourceStack.m_6761_(0))).then(Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(Commands.m_82129_((String)ARG_POSITION, (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Coordinates coordinates = Vec3Argument.m_120849_((CommandContext)context, (String)ARG_POSITION);
            return NavigationCommand.setHomePosition((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), coordinates.m_6955_((CommandSourceStack)context.getSource()));
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"pos").requires(commandSourceStack -> commandSourceStack.m_6761_(0))).then(Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(Commands.m_82129_((String)ARG_POSITION, (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Coordinates coordinates = Vec3Argument.m_120849_((CommandContext)context, (String)ARG_POSITION);
            return NavigationCommand.setPosition((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), coordinates.m_6955_((CommandSourceStack)context.getSource()));
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").requires(commandSourceStack -> commandSourceStack.m_6761_(0))).then(Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> NavigationCommand.reset((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target")))));
    }

    private static int setHomePosition(CommandSourceStack context, EasyNPC<?> easyNPC, Vec3 position) {
        if (easyNPC == null || position == null || position.equals((Object)Vec3.f_82478_)) {
            return 0;
        }
        NavigationData navigationData = easyNPC.getEasyNPCNavigationData();
        if (navigationData == null) {
            return NavigationCommand.sendFailureMessageNoNavigationData(context, easyNPC);
        }
        BlockPos blockPos = new BlockPos(position);
        navigationData.setHomePosition(blockPos);
        return NavigationCommand.sendSuccessMessage(context, "Set home position for EasyNPC " + String.valueOf(easyNPC) + " with UUID " + String.valueOf(easyNPC.getEntityUUID()) + " to " + String.valueOf(blockPos));
    }

    private static int setPosition(CommandSourceStack context, EasyNPC<?> easyNPC, Vec3 position) {
        if (easyNPC == null || position == null || position.equals((Object)Vec3.f_82478_)) {
            return 0;
        }
        NavigationData navigationData = easyNPC.getEasyNPCNavigationData();
        if (navigationData == null) {
            return NavigationCommand.sendFailureMessageNoNavigationData(context, easyNPC);
        }
        navigationData.setPosition(position);
        return NavigationCommand.sendSuccessMessage(context, "Set position for EasyNPC " + String.valueOf(easyNPC) + " with UUID " + String.valueOf(easyNPC.getEntityUUID()) + " to " + String.valueOf(position));
    }

    private static int reset(CommandSourceStack context, EasyNPC<?> easyNPC) {
        if (easyNPC == null) {
            return 0;
        }
        NavigationData navigationData = easyNPC.getEasyNPCNavigationData();
        if (navigationData == null) {
            return NavigationCommand.sendFailureMessageNoNavigationData(context, easyNPC);
        }
        navigationData.getGroundPathNavigation().m_26569_();
        return NavigationCommand.sendSuccessMessage(context, "Reset navigation for EasyNPC " + String.valueOf(easyNPC));
    }
}

