/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.renderer.entity.state.EasyNPCRenderStateExtension;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.UUID;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;

public class EasyNPCLivingEntityRenderer {
    public static void handleRenderStart(LivingEntityRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
    }

    public static void handleRenderEnd(LivingEntityRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
    }

    public static void handleScale(LivingEntityRenderState renderState, PoseStack poseStack) {
        CustomScale customScale;
        EasyNPC<?> easyNPC = EasyNPCLivingEntityRenderer.getEasyNPC(renderState);
        if (easyNPC == null) {
            return;
        }
        ModelData modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            return;
        }
        CustomScale defaultScale = modelData.getDefaultModelScale();
        if (defaultScale != null && defaultScale.hasChanged()) {
            poseStack.scale(defaultScale.x(), defaultScale.y(), defaultScale.z());
        }
        if ((customScale = modelData.getModelPartScale(ModelPartType.ROOT)) != null && customScale.hasChanged()) {
            poseStack.scale(customScale.x(), customScale.y(), customScale.z());
        }
    }

    public static EasyNPC<?> getEasyNPC(LivingEntityRenderState livingEntityRenderState) {
        EasyNPCRenderStateExtension easyNPCRenderStateExtension;
        UUID uuid;
        if (livingEntityRenderState instanceof EasyNPCRenderStateExtension && (uuid = (easyNPCRenderStateExtension = (EasyNPCRenderStateExtension)livingEntityRenderState).getEasyNpcUUID()) != null) {
            return LivingEntityManager.getEasyNPCEntityByUUID(uuid);
        }
        return null;
    }
}

