/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity;

import de.markusbordihn.easynpc.client.model.ModModelLayers;
import de.markusbordihn.easynpc.client.renderer.entity.custom.DopplerRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.custom.FairyRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.custom.OrcRenderer;
import de.markusbordihn.easynpc.entity.ModCustomEntityType;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.world.entity.Entity;

public enum ModCustomEntityRenderer {
    DOPPLER(ModCustomEntityType.DOPPLER, () -> DopplerRenderer::new),
    FAIRY(ModCustomEntityType.FAIRY, () -> context -> new FairyRenderer((EntityRendererProvider.Context)context, ModModelLayers.FAIRY)),
    ORC(ModCustomEntityType.ORC, () -> context -> new OrcRenderer((EntityRendererProvider.Context)context, ModModelLayers.ORC)),
    ORC_WARRIOR(ModCustomEntityType.ORC_WARRIOR, () -> context -> new OrcRenderer((EntityRendererProvider.Context)context, ModModelLayers.ORC));

    private final ModCustomEntityType entityType;
    private final Supplier<Function<EntityRendererProvider.Context, EntityRenderer<? extends Entity, ? extends EntityRenderState>>> renderer;

    private ModCustomEntityRenderer(ModCustomEntityType entityType, Supplier<Function<EntityRendererProvider.Context, EntityRenderer<? extends Entity, ? extends EntityRenderState>>> renderer) {
        this.entityType = entityType;
        this.renderer = renderer;
    }

    public ModCustomEntityType getEntityType() {
        return this.entityType;
    }

    public Function<EntityRendererProvider.Context, EntityRenderer<? extends Entity, ? extends EntityRenderState>> getRenderer() {
        return this.renderer.get();
    }
}

