/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCEntityRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.state.EasyNPCRenderStateExtension;
import de.markusbordihn.easynpc.client.renderer.manager.EntityTypeManager;
import de.markusbordihn.easynpc.client.renderer.manager.RendererManager;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderData;
import de.markusbordihn.easynpc.entity.easynpc.npc.custom.Doppler;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.PlayerItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DopplerRenderer
extends LivingEntityRenderer<PathfinderMob, PlayerRenderState, PlayerModel>
implements EasyNPCEntityRenderer {
    protected static final Map<Doppler.VariantType, ResourceLocation> TEXTURE_BY_VARIANT_TYPE = (Map)Util.make(new EnumMap(Doppler.VariantType.class), map -> map.put(Doppler.VariantType.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/doppler/doppler.png")));
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT_TYPE.get((Object)Doppler.VariantType.DEFAULT);
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public DopplerRenderer(EntityRendererProvider.Context context) {
        this(context, false);
    }

    public DopplerRenderer(EntityRendererProvider.Context context, boolean slim) {
        super(context, (EntityModel)new PlayerModel(context.bakeLayer(slim ? ModelLayers.PLAYER_SLIM : ModelLayers.PLAYER), slim), 0.5f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(slim ? ModelLayers.PLAYER_SLIM_INNER_ARMOR : ModelLayers.PLAYER_INNER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(slim ? ModelLayers.PLAYER_SLIM_OUTER_ARMOR : ModelLayers.PLAYER_OUTER_ARMOR)), context.getEquipmentRenderer()));
        this.addLayer((RenderLayer)new PlayerItemInHandLayer((RenderLayerParent)this, context.getItemRenderer()));
    }

    private static boolean renderEntity(EasyNPC<?> entity, EntityModel<?> entityModel, PlayerRenderState renderState, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (!(entity instanceof EasyNPC)) {
            return false;
        }
        EasyNPC<?> easyNPC = entity;
        RenderData renderData = easyNPC.getEasyNPCRenderData();
        if (renderData == null || renderData.getRenderDataSet() == null || renderData.getRenderDataSet().getRenderType() != RenderType.CUSTOM_ENTITY) {
            return false;
        }
        EntityType<? extends Entity> renderEntityType = renderData.getRenderDataSet().getRenderEntityType();
        PathfinderMob customEntity = EntityTypeManager.getPathfinderMob(renderEntityType, entity.getEntityLevel());
        if (customEntity == null) {
            return false;
        }
        String entityTypeName = EntityTypeManager.getEntityTypeName(renderEntityType);
        LivingEntityRenderer<? extends LivingEntity, ? extends LivingEntityRenderState, ? extends EntityModel<? extends EntityRenderState>> livingEntityRenderer = RendererManager.getLivingEntityRenderer(renderEntityType, customEntity);
        LivingEntityRenderState livingEntityRenderState = (LivingEntityRenderState)livingEntityRenderer.createRenderState((Entity)customEntity, 0.0f);
        if (livingEntityRenderState instanceof EasyNPCRenderStateExtension) {
            EasyNPCRenderStateExtension extension = (EasyNPCRenderStateExtension)livingEntityRenderState;
            extension.setEasyNpcUUID(easyNPC.getEntityUUID());
        }
        if (livingEntityRenderer != null) {
            try {
                RendererManager.copyCustomLivingEntityData(entity.getPathfinderMob(), (LivingEntity)customEntity, entityTypeName);
                livingEntityRenderer.render(livingEntityRenderState, poseStack, buffer, packedLight);
                return true;
            }
            catch (Exception exception) {
                log.error("Failed to render custom living entity {} ({}):", (Object)customEntity, renderEntityType, (Object)exception);
                EntityTypeManager.addUnsupportedEntityType(renderEntityType);
                return false;
            }
        }
        EntityRenderer<? extends Entity, ? extends EntityRenderState> entityRenderer = RendererManager.getEntityRenderer(renderEntityType, customEntity);
        EntityRenderState entityRenderState = entityRenderer.createRenderState((Entity)customEntity, 0.0f);
        if (entityRenderState instanceof EasyNPCRenderStateExtension) {
            EasyNPCRenderStateExtension extension = (EasyNPCRenderStateExtension)entityRenderState;
            extension.setEasyNpcUUID(easyNPC.getEntityUUID());
        }
        if (entityRenderer != null) {
            try {
                RendererManager.copyCustomLivingEntityData(entity.getPathfinderMob(), (LivingEntity)customEntity, entityTypeName);
                entityRenderer.render(entityRenderState, poseStack, buffer, packedLight);
                return true;
            }
            catch (Exception exception) {
                log.error("Failed to render custom entity {} ({}):", (Object)customEntity, renderEntityType, (Object)exception);
                EntityTypeManager.addUnsupportedEntityType(renderEntityType);
                return false;
            }
        }
        return false;
    }

    public PlayerRenderState createRenderState() {
        return new PlayerRenderState();
    }

    public ResourceLocation getTextureLocation(PlayerRenderState renderState) {
        EasyNPC easyNPC = this.getEasyNPC((LivingEntityRenderState)renderState);
        if (easyNPC != null) {
            return this.getEntityTexture(easyNPC);
        }
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getTextureByVariant(Enum<?> variantType) {
        return TEXTURE_BY_VARIANT_TYPE != null ? TEXTURE_BY_VARIANT_TYPE.getOrDefault(variantType, DEFAULT_TEXTURE) : Constants.BLANK_ENTITY_TEXTURE;
    }

    public void render(PlayerRenderState renderState, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        EasyNPC easyNPC = this.getEasyNPC((LivingEntityRenderState)renderState);
        if (DopplerRenderer.renderEntity(easyNPC, this.getModel(), renderState, poseStack, buffer, packedLight)) {
            return;
        }
        super.render((LivingEntityRenderState)renderState, poseStack, buffer, packedLight);
    }
}

