/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.custom;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.model.custom.FairyModel;
import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCEntityRenderer;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.npc.custom.Fairy;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;

public class FairyRenderer
extends HumanoidMobRenderer<Fairy, HumanoidRenderState, FairyModel<HumanoidRenderState>>
implements EasyNPCEntityRenderer {
    protected static final Map<Fairy.VariantType, ResourceLocation> TEXTURE_BY_VARIANT_TYPE = (Map)Util.make(new EnumMap(Fairy.VariantType.class), map -> {
        map.put(Fairy.VariantType.BLUE, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/fairy/fairy_blue.png"));
        map.put(Fairy.VariantType.GREEN, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/fairy/fairy_green.png"));
        map.put(Fairy.VariantType.RED, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/fairy/fairy_red.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT_TYPE.get((Object)Fairy.VariantType.GREEN);

    public FairyRenderer(EntityRendererProvider.Context context, ModelLayerLocation modelLayerLocation) {
        super(context, new FairyModel(context.bakeLayer(modelLayerLocation)), 0.3f);
    }

    public ResourceLocation getTextureLocation(HumanoidRenderState renderState) {
        EasyNPC easyNPC = this.getEasyNPC((LivingEntityRenderState)renderState);
        if (easyNPC != null) {
            return this.getEntityTexture(easyNPC);
        }
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getTextureByVariant(Enum<?> variantType) {
        return TEXTURE_BY_VARIANT_TYPE != null ? TEXTURE_BY_VARIANT_TYPE.getOrDefault(variantType, DEFAULT_TEXTURE) : Constants.BLANK_ENTITY_TEXTURE;
    }

    public HumanoidRenderState createRenderState() {
        return new HumanoidRenderState();
    }
}

