/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.raw;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCEntityRenderer;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.AllayRaw;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.AllayRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.AllayRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;

public class AllayRawRenderer
extends AllayRenderer
implements EasyNPCEntityRenderer {
    protected static final Map<AllayRaw.VariantType, ResourceLocation> TEXTURE_BY_VARIANT_TYPE = (Map)Util.make(new EnumMap(AllayRaw.VariantType.class), map -> {
        map.put(AllayRaw.VariantType.LAVA, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/allay/allay_lava.png"));
        map.put(AllayRaw.VariantType.GRASSLAND, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/allay/allay_grassland.png"));
        map.put(AllayRaw.VariantType.WATER, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/allay/allay_water.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT_TYPE.get((Object)AllayRaw.VariantType.WATER);

    public AllayRawRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(AllayRenderState renderState) {
        EasyNPC easyNPC = this.getEasyNPC((LivingEntityRenderState)renderState);
        if (easyNPC != null) {
            return this.getEntityTexture(easyNPC);
        }
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getTextureByVariant(Enum<?> variantType) {
        return TEXTURE_BY_VARIANT_TYPE != null ? TEXTURE_BY_VARIANT_TYPE.getOrDefault(variantType, DEFAULT_TEXTURE) : Constants.BLANK_ENTITY_TEXTURE;
    }
}

