/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.attribute;

import de.markusbordihn.easynpc.data.attribute.CombatAttributeType;
import de.markusbordihn.easynpc.data.attribute.EntityAttributesInterface;
import net.minecraft.nbt.CompoundTag;

public record CombatAttributes(boolean isAttackable, double healthRegeneration) implements EntityAttributesInterface
{
    public static final String IS_ATTACKABLE_TAG = CombatAttributeType.IS_ATTACKABLE.getTagName();
    public static final String HEALTH_REGENERATION_TAG = CombatAttributeType.HEALTH_REGENERATION.getTagName();

    public CombatAttributes() {
        this(false, 0.0);
    }

    public static CombatAttributes decode(CompoundTag compoundTag) {
        return new CombatAttributes(compoundTag.getBoolean(IS_ATTACKABLE_TAG), compoundTag.getDouble(HEALTH_REGENERATION_TAG));
    }

    public CombatAttributes withHealthRegeneration(double healthRegeneration) {
        return new CombatAttributes(this.isAttackable, healthRegeneration);
    }

    public CombatAttributes withIsAttackable(boolean isAttackable) {
        return new CombatAttributes(isAttackable, this.healthRegeneration);
    }

    public CompoundTag encode(CompoundTag compoundTag) {
        compoundTag.putBoolean(IS_ATTACKABLE_TAG, this.isAttackable());
        compoundTag.putDouble(HEALTH_REGENERATION_TAG, this.healthRegeneration());
        return compoundTag;
    }
}

