/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.position;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record CustomPosition(float x, float y, float z) {
    public static final StreamCodec<RegistryFriendlyByteBuf, CustomPosition> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, CustomPosition>(){

        public CustomPosition decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            return new CustomPosition(registryFriendlyByteBuf.readFloat(), registryFriendlyByteBuf.readFloat(), registryFriendlyByteBuf.readFloat());
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, CustomPosition position) {
            registryFriendlyByteBuf.writeFloat(position.x);
            registryFriendlyByteBuf.writeFloat(position.y);
            registryFriendlyByteBuf.writeFloat(position.z);
        }
    };

    public CustomPosition(ModelPartType modelPartType, CompoundTag compoundTag) {
        this(compoundTag.getList(modelPartType.getTagName(), 5));
    }

    public CustomPosition(ListTag listTag) {
        this(listTag.getFloat(0), listTag.getFloat(1), listTag.getFloat(2));
    }

    public CustomPosition(List<Float> list) {
        this(list.get(0).floatValue(), list.get(1).floatValue(), list.get(2).floatValue());
    }

    public ListTag save() {
        ListTag listTag = new ListTag();
        listTag.add((Object)FloatTag.valueOf((float)this.x));
        listTag.add((Object)FloatTag.valueOf((float)this.y));
        listTag.add((Object)FloatTag.valueOf((float)this.z));
        return listTag;
    }

    public boolean hasChanged() {
        return this.hasChanged(0.0f, 0.0f, 0.0f);
    }

    public boolean hasChanged(float x, float y, float z) {
        return this.x != x || this.y != y || this.z != z;
    }
}

