/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.rotation;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record CustomRotation(float x, float y, float z, boolean locked) {
    public static final StreamCodec<RegistryFriendlyByteBuf, CustomRotation> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, CustomRotation>(){

        public CustomRotation decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            return new CustomRotation(registryFriendlyByteBuf.readFloat(), registryFriendlyByteBuf.readFloat(), registryFriendlyByteBuf.readFloat(), false);
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, CustomRotation rotation) {
            registryFriendlyByteBuf.writeFloat(rotation.x);
            registryFriendlyByteBuf.writeFloat(rotation.y);
            registryFriendlyByteBuf.writeFloat(rotation.z);
            registryFriendlyByteBuf.writeBoolean(rotation.locked);
        }
    };

    public CustomRotation(float x, float y, float z) {
        this(x, y, z, false);
    }

    public CustomRotation(ModelPartType modelPartType, CompoundTag compoundTag) {
        this(compoundTag.getList(modelPartType.getTagName(), 5));
    }

    public CustomRotation(ListTag listTag) {
        this(listTag.getFloat(0), listTag.getFloat(1), listTag.getFloat(2), listTag.getFloat(3) == 1.0f);
    }

    public CustomRotation(List<Float> list) {
        this(list.get(0).floatValue(), list.get(1).floatValue(), list.get(2).floatValue(), list.get(3).floatValue() == 1.0f);
    }

    public CustomRotation withLocked(boolean locked) {
        return new CustomRotation(this.x, this.y, this.z, locked);
    }

    public ListTag save() {
        ListTag listTag = new ListTag();
        listTag.add((Object)FloatTag.valueOf((float)this.x));
        listTag.add((Object)FloatTag.valueOf((float)this.y));
        listTag.add((Object)FloatTag.valueOf((float)this.z));
        listTag.add((Object)FloatTag.valueOf((float)(this.locked ? 1.0f : 0.0f)));
        return listTag;
    }

    public boolean hasChanged() {
        return this.hasChanged(0.0f, 0.0f, 0.0f);
    }

    public boolean hasChangedYaw() {
        return this.x == 0.0f && this.y != 0.0f && this.z == 0.0f && this.locked;
    }

    public boolean hasChanged(float x, float y, float z) {
        return this.hasChanged(x, y, z, false);
    }

    public boolean hasChanged(float x, float y, float z, boolean locked) {
        return this.x != x || this.y != y || this.z != z || this.locked != locked;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        boolean bl2;
        float x1;
        float f;
        if (!(object instanceof CustomRotation)) return false;
        CustomRotation customRotation = (CustomRotation)object;
        try {
            x1 = f = customRotation.x();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        float y1 = f = customRotation.y();
        float z1 = f = customRotation.z();
        boolean locked1 = bl2 = customRotation.locked();
        if (this.x != x1) return false;
        if (this.y != y1) return false;
        if (this.z != z1) return false;
        if (this.locked != locked1) return false;
        return true;
    }
}

