/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.skin;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.data.skin.SkinType;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record SkinDataEntry(String name, String url, UUID uuid, SkinType type, String content, long timestamp) {
    static final String DATA_NAME_TAG = "Name";
    static final String DATA_TYPE_TAG = "Type";
    static final String DATA_URL_TAG = "URL";
    static final String DATA_UUID_TAG = "UUID";
    static final String DATA_CONTENT_TAG = "Content";
    static final String DATA_TIMESTAMP_TAG = "Timestamp";
    public static final StreamCodec<RegistryFriendlyByteBuf, SkinDataEntry> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SkinDataEntry>(){

        public SkinDataEntry decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            return new SkinDataEntry(registryFriendlyByteBuf.readNbt());
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, SkinDataEntry skinDataEntry) {
            registryFriendlyByteBuf.writeNbt((Tag)skinDataEntry.createTag());
        }
    };

    public SkinDataEntry() {
        this("", "", Constants.BLANK_UUID, SkinType.DEFAULT, "", System.currentTimeMillis());
    }

    public SkinDataEntry(String name, String url, UUID uuid, SkinType type) {
        this(name, url, uuid, type, "", System.currentTimeMillis());
    }

    public SkinDataEntry(CompoundTag compoundTag) {
        this(compoundTag.contains(DATA_NAME_TAG) ? compoundTag.getString(DATA_NAME_TAG) : "", compoundTag.contains(DATA_URL_TAG) ? compoundTag.getString(DATA_URL_TAG) : "", compoundTag.contains(DATA_UUID_TAG) ? compoundTag.getUUID(DATA_UUID_TAG) : Constants.BLANK_UUID, SkinType.get(compoundTag.getString(DATA_TYPE_TAG)), compoundTag.contains(DATA_CONTENT_TAG) ? compoundTag.getString(DATA_CONTENT_TAG) : "", compoundTag.contains(DATA_TIMESTAMP_TAG) ? compoundTag.getLong(DATA_TIMESTAMP_TAG) : System.currentTimeMillis());
    }

    public SkinDataEntry withName(String name) {
        return new SkinDataEntry(name, this.url, this.uuid, this.type, this.content, this.timestamp);
    }

    public SkinDataEntry withType(SkinType type) {
        return new SkinDataEntry(this.name, this.url, this.uuid, type, this.content, this.timestamp);
    }

    public SkinDataEntry withURL(String url) {
        return new SkinDataEntry(this.name, url, this.uuid, this.type, this.content, this.timestamp);
    }

    public SkinDataEntry withUUID(UUID uuid) {
        return new SkinDataEntry(this.name, this.url, uuid, this.type, this.content, this.timestamp);
    }

    public SkinDataEntry create(CompoundTag compoundTag) {
        return new SkinDataEntry(compoundTag);
    }

    public CompoundTag write(CompoundTag compoundTag) {
        compoundTag.putString(DATA_NAME_TAG, this.name);
        compoundTag.putString(DATA_TYPE_TAG, this.type.name());
        compoundTag.putString(DATA_URL_TAG, this.url);
        compoundTag.putUUID(DATA_UUID_TAG, this.uuid);
        compoundTag.putString(DATA_CONTENT_TAG, this.content);
        compoundTag.putLong(DATA_TIMESTAMP_TAG, this.timestamp);
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.write(new CompoundTag());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        long l;
        String name1;
        Object object2;
        if (!(object instanceof SkinDataEntry)) return false;
        SkinDataEntry skinDataEntry = (SkinDataEntry)object;
        try {
            object2 = skinDataEntry.name();
            name1 = object2;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        object2 = skinDataEntry.url();
        String url1 = object2;
        Object uuid1 = object2 = skinDataEntry.uuid();
        Object type1 = object2 = skinDataEntry.type();
        Object content1 = object2 = skinDataEntry.content();
        long timestamp1 = l = skinDataEntry.timestamp();
        if (!this.name.equals(name1)) return false;
        if (!this.type.equals(type1)) return false;
        if (!this.url.equals(url1)) return false;
        if (!this.uuid.equals(uuid1)) return false;
        if (!this.content.equals(content1)) return false;
        if (this.timestamp != timestamp1) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int result = 16;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.url.hashCode();
        result = 31 * result + this.uuid.hashCode();
        if (!this.content.isEmpty()) {
            result = 31 * result + this.content.hashCode();
        }
        if (this.timestamp != 0L) {
            result = 31 * result + Long.hashCode(this.timestamp);
        }
        return result;
    }

    @Override
    public String toString() {
        return "SkinDataEntry{name=" + this.name + ", type=" + String.valueOf((Object)this.type) + ", url=" + this.url + ", uuid=" + String.valueOf(this.uuid) + ", content=" + this.content + ", timestamp=" + this.timestamp + "}";
    }
}

