/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.skin;

import java.util.Locale;

public enum SkinModel {
    ALLAY,
    CAT,
    CHICKEN,
    CREEPER,
    FAIRY,
    DROWNED,
    EVOKER,
    ENDER_MAN,
    HORSE,
    HUMANOID_SLIM(true),
    HUMANOID(true),
    ILLAGER,
    ILLUSIONER,
    IRON_GOLEM,
    ORC,
    PIG,
    PIGLIN,
    PILLAGER,
    PLAYER,
    SKELETON(true),
    VEX,
    VILLAGER(true),
    VINDICATOR,
    WITCH,
    WOLF,
    ZOMBIE_VILLAGER(true),
    ZOMBIE(true);

    private final boolean hasArmourersWorkshopSupport;

    private SkinModel() {
        this(false);
    }

    private SkinModel(boolean hasArmourersWorkshopSupport) {
        this.hasArmourersWorkshopSupport = hasArmourersWorkshopSupport;
    }

    public static SkinModel get(String skinModel) {
        if (skinModel == null || skinModel.isEmpty()) {
            return HUMANOID;
        }
        try {
            return SkinModel.valueOf(skinModel);
        }
        catch (IllegalArgumentException e) {
            return HUMANOID;
        }
    }

    public boolean hasArmourersWorkshopSupport() {
        return this.hasArmourersWorkshopSupport;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT).replaceAll("[^a-zA-Z0-9/._-]", "").replace("..", "");
    }
}

