/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity;

import de.markusbordihn.easynpc.compat.CompatConstants;
import de.markusbordihn.easynpc.compat.epicfight.entity.EpicFightZombie;
import de.markusbordihn.easynpc.entity.ModCustomEntityType;
import de.markusbordihn.easynpc.entity.ModNPCEntityType;
import de.markusbordihn.easynpc.entity.ModRawEntityType;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntityType {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"easy_npc");
    public static final Map<ModRawEntityType, RegistryObject<EntityType<?>>> RAW_TYPE = new EnumMap(ModRawEntityType.class);
    public static final Map<ModNPCEntityType, RegistryObject<EntityType<?>>> NPC_TYPE = new EnumMap(ModNPCEntityType.class);
    public static final Map<ModCustomEntityType, RegistryObject<EntityType<?>>> CUSTOM_TYPE = new EnumMap(ModCustomEntityType.class);
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    public static RegistryObject<EntityType<EpicFightZombie>> EPIC_FIGHT_ZOMBIE;

    private ModEntityType() {
    }

    public static <T extends Entity> EntityType<T> getEntityType(ModRawEntityType type) {
        if (!RAW_TYPE.containsKey(type)) {
            throw new IllegalArgumentException("Invalid raw entity type '" + String.valueOf(type) + "'! Supported types are " + String.valueOf(RAW_TYPE.keySet()));
        }
        return (EntityType)RAW_TYPE.get(type).get();
    }

    public static <T extends Entity> EntityType<T> getEntityType(ModNPCEntityType type) {
        if (!NPC_TYPE.containsKey(type)) {
            throw new IllegalArgumentException("Invalid NPC entity type '" + String.valueOf(type) + "'! Supported types are " + String.valueOf(NPC_TYPE.keySet()));
        }
        return (EntityType)NPC_TYPE.get(type).get();
    }

    public static <T extends Entity> EntityType<T> getEntityType(ModCustomEntityType type) {
        if (!CUSTOM_TYPE.containsKey(type)) {
            throw new IllegalArgumentException("Invalid NPC entity type '" + String.valueOf(type) + "'! Supported types are " + String.valueOf(CUSTOM_TYPE.keySet()));
        }
        return (EntityType)CUSTOM_TYPE.get(type).get();
    }

    @SubscribeEvent
    public static void entityAttributeCreation(EntityAttributeCreationEvent event) {
        for (ModRawEntityType modRawEntityType : ModRawEntityType.values()) {
            if (modRawEntityType.getAttributes() != null) {
                event.put((EntityType)RAW_TYPE.get(modRawEntityType).get(), modRawEntityType.getAttributes().build());
                continue;
            }
            log.warn("Raw entity type {} does not have attributes defined!", modRawEntityType.getResourceKey());
        }
        for (Enum enum_ : ModNPCEntityType.values()) {
            if (((ModNPCEntityType)enum_).getAttributes() != null) {
                event.put((EntityType)NPC_TYPE.get(enum_).get(), ((ModNPCEntityType)enum_).getAttributes().build());
                continue;
            }
            log.warn("NPC entity type {} does not have attributes defined!", ((ModNPCEntityType)enum_).getResourceKey());
        }
        for (Enum enum_ : ModCustomEntityType.values()) {
            if (((ModCustomEntityType)enum_).getAttributes() != null) {
                event.put((EntityType)CUSTOM_TYPE.get(enum_).get(), ((ModCustomEntityType)enum_).getAttributes().build());
                continue;
            }
            log.warn("Custom entity type {} does not have attributes defined!", ((ModCustomEntityType)enum_).getResourceKey());
        }
        if (CompatConstants.MOD_EPIC_FIGHT_LOADED) {
            event.put((EntityType)EPIC_FIGHT_ZOMBIE.get(), Zombie.createAttributes().build());
        }
    }

    private static /* synthetic */ EntityType lambda$static$2(ModCustomEntityType type) {
        return type.getBuilder().build(type.getResourceKey());
    }

    private static /* synthetic */ EntityType lambda$static$1(ModNPCEntityType type) {
        return type.getBuilder().build(type.getResourceKey());
    }

    static {
        for (ModRawEntityType modRawEntityType : ModRawEntityType.values()) {
            log.info("Registering raw entity type {}", modRawEntityType.getResourceKey());
            RAW_TYPE.put(modRawEntityType, ENTITY_TYPES.register(modRawEntityType.getId(), () -> modRawEntityType.getBuilder().build(modRawEntityType.getResourceKey())));
        }
        for (Enum enum_ : ModNPCEntityType.values()) {
            log.info("Registering NPC entity type {}", ((ModNPCEntityType)enum_).getResourceKey());
            NPC_TYPE.put((ModNPCEntityType)enum_, ENTITY_TYPES.register(((ModNPCEntityType)enum_).getId(), () -> ModEntityType.lambda$static$1((ModNPCEntityType)enum_)));
        }
        for (Enum enum_ : ModCustomEntityType.values()) {
            log.info("Registering custom entity type {}", ((ModCustomEntityType)enum_).getResourceKey());
            CUSTOM_TYPE.put((ModCustomEntityType)enum_, ENTITY_TYPES.register(((ModCustomEntityType)enum_).getId(), () -> ModEntityType.lambda$static$2((ModCustomEntityType)enum_)));
        }
        if (CompatConstants.MOD_EPIC_FIGHT_LOADED) {
            // empty if block
        }
    }
}

