/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.ai.goal;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationData;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class FollowLivingEntityGoal
extends Goal {
    private final PathfinderMob pathfinderMob;
    private final LivingEntity livingEntity;
    private final double speedModifier;
    private final float stopDistance;
    private final float startDistance;
    private final boolean canFly;
    private final PathNavigation pathNavigation;
    private final LevelReader level;
    private float oldWaterCost;
    private int timeToRecalcPath;

    public FollowLivingEntityGoal(EasyNPC<?> easyNPC, LivingEntity livingEntity, double speedModifier, float stopDistance, float startDistance) {
        this.pathfinderMob = easyNPC.getPathfinderMob();
        NavigationData navigationData = easyNPC.getEasyNPCNavigationData();
        this.livingEntity = livingEntity;
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
        this.startDistance = startDistance;
        this.canFly = navigationData.canFly();
        this.pathNavigation = this.pathfinderMob.getNavigation();
        this.level = easyNPC.getEntityServerLevel();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.pathfinderMob != null && this.pathfinderMob.isAlive() && this.livingEntity != null && this.livingEntity.isAlive() && this.pathfinderMob.distanceToSqr((Entity)this.livingEntity) > (double)(this.stopDistance * this.stopDistance) && this.pathfinderMob.distanceToSqr((Entity)this.livingEntity) < (double)(this.startDistance * this.startDistance);
    }

    public boolean canContinueToUse() {
        if (this.pathNavigation.isDone()) {
            return false;
        }
        return this.pathfinderMob.distanceToSqr((Entity)this.livingEntity) > (double)(this.stopDistance * this.stopDistance);
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.pathfinderMob.getPathfindingMalus(PathType.WATER);
        this.pathfinderMob.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.pathNavigation.stop();
        this.pathfinderMob.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        this.pathfinderMob.getLookControl().setLookAt((Entity)this.livingEntity, 10.0f, (float)this.pathfinderMob.getMaxHeadXRot());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            if (!this.pathfinderMob.isLeashed() && !this.pathfinderMob.isPassenger()) {
                if (this.pathfinderMob.distanceToSqr((Entity)this.livingEntity) >= 144.0) {
                    this.teleportToLivingEntity();
                } else {
                    this.pathNavigation.moveTo((Entity)this.livingEntity, this.speedModifier);
                }
            }
        }
    }

    private void teleportToLivingEntity() {
        BlockPos blockPos = this.livingEntity.blockPosition();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean flag = this.maybeTeleportTo(blockPos.getX() + j, blockPos.getY() + k, blockPos.getZ() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int posX, int posY, int posZ) {
        if (Math.abs((double)posX - this.livingEntity.getX()) < 2.0 && Math.abs((double)posZ - this.livingEntity.getZ()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(posX, posY, posZ))) {
            return false;
        }
        this.pathfinderMob.moveTo((double)posX + 0.5, (double)posY, (double)posZ + 0.5, this.pathfinderMob.getYRot(), this.pathfinderMob.getXRot());
        this.pathNavigation.stop();
        return true;
    }

    private boolean canTeleportTo(BlockPos blockPos) {
        PathType blockPathTypes = WalkNodeEvaluator.getPathTypeStatic((Mob)this.pathfinderMob, (BlockPos)blockPos.mutable());
        if (!this.canFly && blockPathTypes != PathType.WALKABLE) {
            return false;
        }
        BlockState blockState = this.level.getBlockState(blockPos.below());
        if (!this.canFly && blockState.getBlock() instanceof LeavesBlock) {
            return false;
        }
        BlockPos targetBlockPos = blockPos.subtract((Vec3i)this.pathfinderMob.blockPosition());
        return this.level.noCollision((Entity)this.pathfinderMob, this.pathfinderMob.getBoundingBox().move(targetBlockPos));
    }

    private int randomIntInclusive(int fromRange, int toRange) {
        return this.pathfinderMob.getRandom().nextInt(toRange - fromRange + 1) + fromRange;
    }
}

