/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelArmPose;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.model.ModelType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelPositionData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelRotationData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelScaleData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelVisibilityData;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;

public interface ModelData<T extends PathfinderMob>
extends EasyNPC<T>,
ModelPositionData<T>,
ModelRotationData<T>,
ModelScaleData<T>,
ModelVisibilityData<T> {
    public static final String EASY_NPC_DATA_MODEL_DATA_TAG = "ModelData";
    public static final String EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG = "DefaultPose";
    public static final String EASY_NPC_DATA_MODEL_POSE_TAG = "Pose";

    public static void registerSyncedModelData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("Registering Synched Model Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.MODEL_POSE, SynchedEntityData.defineId(entityClass, EntityDataSerializersManager.MODEL_POSE));
        ModelPositionData.registerSyncedModelPositionData(map, entityClass);
        ModelRotationData.registerSyncedModelRotationData(map, entityClass);
        ModelScaleData.registerSyncedModelScaleData(map, entityClass);
        ModelVisibilityData.registerSyncedModelVisibilityData(map, entityClass);
    }

    default public Pose getDefaultPose() {
        return this.getEntity().getPose();
    }

    default public void setDefaultPose(Pose pose) {
        this.getEntity().setPose(pose);
    }

    default public ModelPose getModelPose() {
        return (ModelPose)((Object)this.getSynchedEntityData(SynchedDataIndex.MODEL_POSE));
    }

    default public void setModelPose(ModelPose modelPose) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_POSE, modelPose);
    }

    default public ModelType getModelType() {
        return ModelType.HUMANOID;
    }

    default public ModelArmPose getModelArmPose() {
        return this.getModelArmPose(this.getLivingEntity());
    }

    default public ModelArmPose getModelArmPose(LivingEntity livingEntity) {
        Mob mob;
        boolean isAggressive = livingEntity instanceof Mob && (mob = (Mob)livingEntity).isAggressive();
        ItemStack itemStack = livingEntity.getMainHandItem();
        if (isAggressive && AttackHandler.isBowWeapon(itemStack)) {
            return ModelArmPose.BOW_AND_ARROW;
        }
        AttackData attackData = this.getEasyNPCAttackData();
        if (AttackHandler.isCrossbowWeapon(itemStack)) {
            if (attackData.isChargingCrossbow()) {
                return ModelArmPose.CROSSBOW_CHARGE;
            }
            if (isAggressive) {
                return ModelArmPose.CROSSBOW_HOLD;
            }
        }
        if (isAggressive && AttackHandler.isGunWeapon(itemStack)) {
            return ModelArmPose.GUN_HOLD;
        }
        if (isAggressive && AttackHandler.isMeeleeWeapon(itemStack)) {
            return ModelArmPose.ATTACKING_WITH_MELEE_WEAPON;
        }
        return isAggressive ? ModelArmPose.ATTACKING : ModelArmPose.NEUTRAL;
    }

    default public boolean canUseArmor() {
        return false;
    }

    default public boolean canUseMainHand() {
        return true;
    }

    default public boolean canUseOffHand() {
        return true;
    }

    default public boolean hasChangedModel() {
        return this.hasChangedModelPosition() || this.hasChangedModelRotation() || this.hasChangedModelScale() || this.hasChangedModelVisibility();
    }

    default public void defineSynchedModelData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_POSE, ModelPose.DEFAULT);
        this.defineSynchedModelPositionData(builder);
        this.defineSynchedModelRotationData(builder);
        this.defineSynchedModelScaleData(builder);
        this.defineSynchedModelVisibilityData(builder);
    }

    default public void addAdditionalModelData(CompoundTag compoundTag) {
        CompoundTag modelDataTag = new CompoundTag();
        if (this.getModelPose() != ModelPose.DEFAULT && this.hasChangedModel()) {
            modelDataTag.putString(EASY_NPC_DATA_MODEL_POSE_TAG, this.getModelPose().name());
            modelDataTag.putString(EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG, Pose.STANDING.name());
        } else {
            modelDataTag.putString(EASY_NPC_DATA_MODEL_POSE_TAG, ModelPose.DEFAULT.name());
            modelDataTag.putString(EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG, this.getDefaultPose() != null ? this.getDefaultPose().name() : Pose.STANDING.name());
        }
        this.addAdditionalModelPositionData(modelDataTag);
        this.addAdditionalModelRotationData(modelDataTag);
        this.addAdditionalModelScaleData(modelDataTag);
        this.addAdditionalModelVisibilityData(modelDataTag);
        compoundTag.put(EASY_NPC_DATA_MODEL_DATA_TAG, (Tag)modelDataTag);
    }

    default public void readAdditionalModelData(CompoundTag compoundTag) {
        String defaultPose;
        String modelPose;
        if (!compoundTag.contains(EASY_NPC_DATA_MODEL_DATA_TAG)) {
            return;
        }
        CompoundTag modelDataTag = compoundTag.getCompound(EASY_NPC_DATA_MODEL_DATA_TAG);
        if (modelDataTag.contains(EASY_NPC_DATA_MODEL_POSE_TAG) && !(modelPose = modelDataTag.getString(EASY_NPC_DATA_MODEL_POSE_TAG)).isEmpty()) {
            this.setModelPose(ModelPose.get(modelPose));
        }
        if (this.getModelPose() == ModelPose.DEFAULT && modelDataTag.contains(EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG) && !(defaultPose = modelDataTag.getString(EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG)).isEmpty()) {
            this.setDefaultPose(Pose.valueOf((String)defaultPose));
        }
        this.readAdditionalModelPositionData(modelDataTag);
        this.readAdditionalModelRotationData(modelDataTag);
        this.readAdditionalModelScaleData(modelDataTag);
        this.readAdditionalModelVisibilityData(modelDataTag);
    }
}

