/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.attribute.EntityAttributes;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.data.ticker.TickerType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttributeData;
import de.markusbordihn.easynpc.entity.easynpc.data.ObjectiveData;
import de.markusbordihn.easynpc.entity.easynpc.data.TickerData;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public interface NavigationData<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final String DATA_HOME_TAG = "Home";
    public static final String DATA_NAVIGATION_TAG = "Navigation";
    public static final int TRAVEL_EVENT_TICK = 20;

    public static void registerSyncedNavigationData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Navigation Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.NAVIGATION_HOME_POSITION, SynchedEntityData.defineId(entityClass, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS));
    }

    default public BlockPos getHomePosition() {
        return (BlockPos)this.getSynchedEntityData(SynchedDataIndex.NAVIGATION_HOME_POSITION);
    }

    default public void setHomePosition(BlockPos blockPos) {
        this.setSynchedEntityData(SynchedDataIndex.NAVIGATION_HOME_POSITION, blockPos);
    }

    default public boolean hasHomePosition() {
        return this.getHomePosition() != null && !this.getHomePosition().equals((Object)BlockPos.ZERO);
    }

    default public void setPosition(Vec3 pos) {
        this.getLivingEntity().setPos(pos);
        this.getLivingEntity().moveTo(pos);
    }

    default public void refreshGroundNavigation() {
        EntityAttributes attributeData;
        GroundPathNavigation groundPathNavigation = this.getGroundPathNavigation();
        if (groundPathNavigation == null) {
            return;
        }
        EntityAttributes entityAttributes = attributeData = this.getEasyNPCAttributeData() != null ? this.getEasyNPCAttributeData().getEntityAttributes() : null;
        if (attributeData != null && attributeData.hasMovementAttributes()) {
            groundPathNavigation.setCanOpenDoors(attributeData.getMovementAttributes().canOpenDoor());
            groundPathNavigation.setCanPassDoors(attributeData.getMovementAttributes().canPassDoor());
            groundPathNavigation.setCanFloat(attributeData.getEnvironmentalAttributes().canFloat());
        } else {
            groundPathNavigation.setCanOpenDoors(true);
            groundPathNavigation.setCanPassDoors(true);
            groundPathNavigation.setCanFloat(true);
        }
    }

    default public GroundPathNavigation getGroundPathNavigation() {
        Mob mob;
        NavigationData navigationData = this;
        if (navigationData instanceof Mob && (navigationData = (mob = (Mob)navigationData).getNavigation()) instanceof GroundPathNavigation) {
            GroundPathNavigation groundPathNavigation = (GroundPathNavigation)navigationData;
            return groundPathNavigation;
        }
        return null;
    }

    default public void defineSynchedNavigationData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.NAVIGATION_HOME_POSITION, BlockPos.ZERO);
    }

    default public boolean canFly() {
        return false;
    }

    default public boolean isFlying() {
        return this.canFly() && !this.getEntity().onGround();
    }

    default public void addAdditionalNavigationData(CompoundTag compoundTag) {
        CompoundTag navigationTag = new CompoundTag();
        if (this.hasHomePosition()) {
            navigationTag.put(DATA_HOME_TAG, (Tag)CompoundTagUtils.writeBlockPos(this.getHomePosition()));
        }
        compoundTag.put(DATA_NAVIGATION_TAG, (Tag)navigationTag);
    }

    default public void readAdditionalNavigationData(CompoundTag compoundTag) {
        if (!compoundTag.contains(DATA_NAVIGATION_TAG)) {
            return;
        }
        CompoundTag navigationTag = compoundTag.getCompound(DATA_NAVIGATION_TAG);
        if (navigationTag.contains(DATA_HOME_TAG)) {
            this.setHomePosition(CompoundTagUtils.readBlockPos(navigationTag.getCompound(DATA_HOME_TAG)));
        }
    }

    default public void handleNavigationTravelEvent(Vec3 vec3) {
        TickerData tickerData = this.getEasyNPCTickerData();
        if (tickerData.checkAndIncreaseTicker(TickerType.TRAVEL_EVENT, 20)) {
            Mob mob = this.getMob();
            Level level = this.getEntityLevel();
            BlockState blockState = level.getBlockState(mob.getOnPos());
            mob.setOnGround(!blockState.is(Blocks.AIR) && !blockState.is(Blocks.GRASS_BLOCK) && !blockState.is(Blocks.WHITE_CARPET) && !blockState.is(Blocks.RED_CARPET));
            ObjectiveData objectiveData = this.getEasyNPCObjectiveData();
            AttributeData attributeData = this.getEasyNPCAttributeData();
            if (!objectiveData.hasTravelTargetObjectives() && attributeData.getEntityAttributes().getEnvironmentalAttributes().freefall() && !mob.onGround()) {
                mob.setPos(mob.getX(), Math.floor(mob.getY() - 0.1), mob.getZ());
            }
            tickerData.resetTicker(TickerType.TRAVEL_EVENT);
        }
    }
}

