/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc.standard;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.HorseRaw;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HorseNPC
extends HorseRaw {
    public static final String ID = "horse";
    public static final String ID_SKELETON = "horse_skeleton";
    public static final String ID_ZOMBIE = "horse_zombie";

    public HorseNPC(EntityType<? extends Horse> entityType, Level level) {
        this(entityType, level, HorseRaw.VariantType.WHITE);
    }

    public HorseNPC(EntityType<? extends Horse> entityType, Level level, Enum<?> variantType) {
        super(entityType, level, variantType);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_SPEED, 0.0).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0);
    }

    @Override
    public boolean canUseOffHand() {
        return false;
    }

    @Override
    public boolean canUseMainHand() {
        return false;
    }

    @Override
    public SkinModel getSkinModel() {
        return SkinModel.WOLF;
    }

    @Override
    public int getEntityGuiTop() {
        return -15;
    }

    @Override
    public int getEntityDialogTop() {
        return -37;
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.HORSE_AMBIENT);
        soundDataSet.addSound(SoundType.DEATH, SoundEvents.HORSE_DEATH);
        soundDataSet.addSound(SoundType.EAT, SoundEvents.HORSE_EAT);
        soundDataSet.addSound(SoundType.HURT, SoundEvents.HORSE_HURT);
        soundDataSet.addSound(SoundType.STEP, SoundEvents.HORSE_STEP);
        soundDataSet.addSound(SoundType.TRADE, SoundEvents.VILLAGER_TRADE);
        soundDataSet.addSound(SoundType.TRADE_YES, SoundEvents.VILLAGER_YES);
        soundDataSet.addSound(SoundType.TRADE_NO, SoundEvents.VILLAGER_NO);
        return soundDataSet;
    }

    protected void registerGoals() {
    }

    @Override
    public void travel(Vec3 vec3) {
        this.handleNavigationTravelEvent(vec3);
        if (this.hasTravelTargetObjectives()) {
            super.travel(vec3);
        } else {
            this.calculateEntityAnimation(this instanceof FlyingAnimal);
        }
    }
}

