/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.item.configuration;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class MoveEasyNPCItem
extends Item {
    public static final String ID = "move_easy_npc";
    private final Map<Player, LivingEntity> targetedLivingEntityMap = new HashMap<Player, LivingEntity>();

    public MoveEasyNPCItem(Item.Properties properties) {
        super(properties.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)ID))));
    }

    public InteractionResult interactLivingEntity(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        if (!player.level().isClientSide && livingEntity instanceof EasyNPC) {
            ServerPlayer serverPlayer;
            EasyNPC easyNPC = (EasyNPC)livingEntity;
            if (player instanceof ServerPlayer && ((serverPlayer = (ServerPlayer)player).isCreative() || easyNPC.getEasyNPCOwnerData() == null && easyNPC.getEasyNPCOwnerData().isOwner(serverPlayer))) {
                this.targetedLivingEntityMap.put(player, livingEntity);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean canAttackBlock(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        if (!player.level().isClientSide && this.targetedLivingEntityMap.containsKey(player)) {
            LivingEntity targetedLivingEntity = this.targetedLivingEntityMap.get(player);
            targetedLivingEntity.moveTo((double)blockPos.getX() + 0.5, (double)blockPos.above().getY(), (double)blockPos.getZ() + 0.5);
        }
        return false;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        tooltipList.add((Component)TextComponent.getTranslatedTextRaw("text.easy_npc.item.move_easy_npc"));
    }
}

