/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.client;

import de.markusbordihn.easynpc.data.dialog.DialogDataManager;
import de.markusbordihn.easynpc.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.menu.ClientMenuManager;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record OpenMenuCallbackMessage(UUID uuid, UUID menuId, CompoundTag data) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"open_menu_callback_message");
    public static final CustomPacketPayload.Type<OpenMenuCallbackMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenMenuCallbackMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), OpenMenuCallbackMessage::create);

    public static OpenMenuCallbackMessage create(FriendlyByteBuf buffer) {
        return new OpenMenuCallbackMessage(buffer.readUUID(), buffer.readUUID(), buffer.readNbt());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeUUID(this.menuId);
        buffer.writeNbt((Tag)this.data);
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<OpenMenuCallbackMessage> type() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleClient() {
        AdditionalScreenData additionalScreenData;
        UUID uuid = this.uuid;
        UUID menuId = this.menuId;
        CompoundTag data = this.data;
        if (uuid == null || menuId == null || data == null) {
            log.error("Invalid menu data received for {} with menuId {} and data: {}", (Object)uuid, (Object)menuId, (Object)data);
            return;
        }
        ClientMenuManager.setMenuData(menuId, data);
        if (ClientMenuManager.hasAdditionalScreenData() && (additionalScreenData = ClientMenuManager.getAdditionalScreenData()).hasDialogDataSet()) {
            DialogDataManager.addDialogDataSet(this.uuid, additionalScreenData.getDialogDataSet());
        }
        NetworkMessageHandlerManager.getServerHandler().openMenu(uuid, menuId);
    }
}

