/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.syncher;

import de.markusbordihn.easynpc.data.action.ActionEventSet;
import de.markusbordihn.easynpc.data.attribute.CustomAttributes;
import de.markusbordihn.easynpc.data.attribute.EntityAttributes;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.display.DisplayAttributeSet;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataSet;
import de.markusbordihn.easynpc.data.objective.TargetedEntitySet;
import de.markusbordihn.easynpc.data.objective.TargetedPlayerSet;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.data.skin.SkinDataEntry;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.data.skin.SkinUUID;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.trading.TradingDataSet;
import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelPositionData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelRotationData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelScaleData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelVisibilityData;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.item.trading.MerchantOffers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityDataSerializersManager {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final Map<String, EntityDataSerializer<?>> ENTITY_DATA_SERIALIZERS = new LinkedHashMap();
    public static final EntityDataSerializer<ActionEventSet> ACTION_EVENT_SET = EntityDataSerializersManager.defineSerializer(ActionEventSet.class.getSimpleName(), EntityDataSerializer.forValueType(ActionEventSet.STREAM_CODEC));
    public static final EntityDataSerializer<CustomAttributes> CUSTOM_ATTRIBUTES = EntityDataSerializersManager.defineSerializer(CustomAttributes.class.getSimpleName(), EntityDataSerializer.forValueType(CustomAttributes.STREAM_CODEC));
    public static final EntityDataSerializer<DialogDataSet> DIALOG_DATA_SET = EntityDataSerializersManager.defineSerializer(DialogDataSet.class.getSimpleName(), EntityDataSerializer.forValueType(DialogDataSet.STREAM_CODEC));
    public static final EntityDataSerializer<DisplayAttributeSet> DISPLAY_ATTRIBUTE_SET = EntityDataSerializersManager.defineSerializer(DisplayAttributeSet.class.getSimpleName(), EntityDataSerializer.forValueType(DisplayAttributeSet.STREAM_CODEC));
    public static final EntityDataSerializer<EntityAttributes> ENTITY_ATTRIBUTES = EntityDataSerializersManager.defineSerializer(EntityAttributes.class.getSimpleName(), EntityDataSerializer.forValueType(EntityAttributes.STREAM_CODEC));
    public static final EntityDataSerializer<MerchantOffers> MERCHANT_OFFERS = EntityDataSerializersManager.defineSerializer(MerchantOffers.class.getSimpleName(), EntityDataSerializer.forValueType((StreamCodec)MerchantOffers.STREAM_CODEC));
    public static final EntityDataSerializer<ModelPose> MODEL_POSE = EntityDataSerializersManager.defineSerializer(ModelPose.class.getSimpleName(), EntityDataSerializer.forValueType(ModelPose.STREAM_CODEC));
    public static final EntityDataSerializer<ObjectiveDataSet> OBJECTIVE_DATA_SET = EntityDataSerializersManager.defineSerializer(ObjectiveDataSet.class.getSimpleName(), EntityDataSerializer.forValueType(ObjectiveDataSet.STREAM_CODEC));
    public static final EntityDataSerializer<CustomPosition> POSITION = EntityDataSerializersManager.defineSerializer(CustomPosition.class.getSimpleName(), EntityDataSerializer.forValueType(CustomPosition.STREAM_CODEC));
    public static final EntityDataSerializer<Profession> PROFESSION = EntityDataSerializersManager.defineSerializer(Profession.class.getSimpleName(), EntityDataSerializer.forValueType(Profession.STREAM_CODEC));
    public static final EntityDataSerializer<RenderDataSet> RENDER_DATA_SET = EntityDataSerializersManager.defineSerializer(RenderDataSet.class.getSimpleName(), EntityDataSerializer.forValueType(RenderDataSet.STREAM_CODEC));
    public static final EntityDataSerializer<CustomScale> SCALE = EntityDataSerializersManager.defineSerializer(CustomScale.class.getSimpleName(), EntityDataSerializer.forValueType(CustomScale.STREAM_CODEC));
    public static final EntityDataSerializer<SkinDataEntry> SKIN_DATA_ENTRY = EntityDataSerializersManager.defineSerializer(SkinDataEntry.class.getSimpleName(), EntityDataSerializer.forValueType(SkinDataEntry.STREAM_CODEC));
    public static final EntityDataSerializer<SkinType> SKIN_TYPE = EntityDataSerializersManager.defineSerializer(SkinType.class.getSimpleName(), EntityDataSerializer.forValueType(SkinType.STREAM_CODEC));
    public static final EntityDataSerializer<UUID> SKIN_UUID = EntityDataSerializersManager.defineSerializer(SkinUUID.class.getSimpleName(), EntityDataSerializer.forValueType(SkinUUID.STREAM_CODEC));
    public static final EntityDataSerializer<SoundDataSet> SOUND_DATA_SET = EntityDataSerializersManager.defineSerializer(SoundDataSet.class.getSimpleName(), EntityDataSerializer.forValueType(SoundDataSet.STREAM_CODEC));
    public static final EntityDataSerializer<HashSet<UUID>> TARGETED_ENTITY_HASH_SET = EntityDataSerializersManager.defineSerializer(TargetedEntitySet.class.getSimpleName(), EntityDataSerializer.forValueType(TargetedEntitySet.STREAM_CODEC));
    public static final EntityDataSerializer<HashSet<String>> TARGETED_PLAYER_HASH_SET = EntityDataSerializersManager.defineSerializer(TargetedPlayerSet.class.getSimpleName(), EntityDataSerializer.forValueType(TargetedPlayerSet.STREAM_CODEC));
    public static final EntityDataSerializer<TradingDataSet> TRADING_DATA_SET = EntityDataSerializersManager.defineSerializer(TradingDataSet.class.getSimpleName(), EntityDataSerializer.forValueType(TradingDataSet.STREAM_CODEC));
    public static final EntityDataSerializer<TradingType> TRADING_TYPE = EntityDataSerializersManager.defineSerializer(TradingType.class.getSimpleName(), EntityDataSerializer.forValueType(TradingType.STREAM_CODEC));
    public static final EntityDataSerializer<UUID> UUID = EntityDataSerializersManager.defineSerializer(UUID.class.getSimpleName(), EntityDataSerializer.forValueType((StreamCodec)UUIDUtil.STREAM_CODEC));
    public static final EntityDataSerializer<Map<ModelPartType, Boolean>> MODEL_PART_VISIBILITY = EntityDataSerializersManager.defineSerializer(ModelVisibilityData.class.getSimpleName(), EntityDataSerializer.forValueType(ModelVisibilityData.MODEL_PART_VISIBILITY_STREAM_CODEC));
    public static final EntityDataSerializer<Map<ModelPartType, CustomRotation>> MODEL_PART_ROTATION = EntityDataSerializersManager.defineSerializer(ModelRotationData.class.getSimpleName(), EntityDataSerializer.forValueType(ModelRotationData.MODEL_PART_ROTATION_STREAM_CODEC));
    public static final EntityDataSerializer<Map<ModelPartType, CustomPosition>> MODEL_PART_POSITION = EntityDataSerializersManager.defineSerializer(ModelPositionData.class.getSimpleName(), EntityDataSerializer.forValueType(ModelPositionData.MODEL_PART_POSITION_STREAM_CODEC));
    public static final EntityDataSerializer<Map<ModelPartType, CustomScale>> MODEL_PART_SCALE = EntityDataSerializersManager.defineSerializer(ModelScaleData.class.getSimpleName(), EntityDataSerializer.forValueType(ModelScaleData.MODEL_PART_SCALE_STREAM_CODEC));

    private EntityDataSerializersManager() {
    }

    public static <T> EntityDataSerializer<T> defineSerializer(String className, EntityDataSerializer<T> serializer) {
        if (ENTITY_DATA_SERIALIZERS.containsKey(className)) {
            log.error("Entity data serializer {} already defined with {}!", (Object)className, ENTITY_DATA_SERIALIZERS.get(className));
            return null;
        }
        ENTITY_DATA_SERIALIZERS.put(className, serializer);
        return serializer;
    }

    public static void register() {
        for (Map.Entry<String, EntityDataSerializer<?>> entry : ENTITY_DATA_SERIALIZERS.entrySet()) {
            EntityDataSerializer<?> serializer = entry.getValue();
            if (serializer == null) {
                log.error("Failed to register entity data serializer {}", (Object)entry.getKey());
                continue;
            }
            EntityDataSerializers.registerSerializer(serializer);
            int id = EntityDataSerializers.getSerializedId(serializer);
            if (id >= 0) {
                log.info("Registered entity data serializer {} with id {}", (Object)entry.getKey(), (Object)id);
                continue;
            }
            log.error("Failed to register entity data serializer {} with {}", (Object)entry.getKey(), serializer);
        }
    }
}

