/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.screen;

import com.mojang.blaze3d.platform.Lighting;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.entity.easynpc.data.GuiData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.entity.easynpc.data.ProfessionData;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.scores.PlayerTeam;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ScreenHelper {
    protected ScreenHelper() {
    }

    public static void renderEntity(GuiGraphics guiGraphics, int x, int y, int scale, float yRot, float xRot, LivingEntity livingEntity) {
        boolean isDead = livingEntity.isDeadOrDying();
        Minecraft minecraft = Minecraft.getInstance();
        float rotationY = (float)Math.atan((isDead ? 25.0f : yRot) / 40.0f);
        float rotationX = (float)Math.atan((isDead ? -25.0f : xRot) / 40.0f);
        Quaternionf quaternionfZ = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionfX = new Quaternionf().rotateX(rotationX * 20.0f * ((float)Math.PI / 180));
        quaternionfZ.mul((Quaternionfc)quaternionfX);
        Component entityCustomName = livingEntity.getCustomName();
        boolean entityShouldShowName = livingEntity.shouldShowName();
        float entityXRot = livingEntity.getXRot();
        float entityYBodyRot = livingEntity.yBodyRot;
        float entityYHeadRot = livingEntity.yHeadRot;
        float entityYHeadRotO = livingEntity.yHeadRotO;
        float entityYRot = livingEntity.getYRot();
        boolean entityInvisible = livingEntity.isInvisible();
        PlayerTeam entityTeam = livingEntity.getTeam();
        livingEntity.setInvisible(false);
        livingEntity.yBodyRot = 180.0f + rotationY * 20.0f;
        livingEntity.setYRot(180.0f + rotationY * 40.0f);
        livingEntity.setXRot(-rotationX * 20.0f);
        livingEntity.yHeadRot = livingEntity.getYRot();
        livingEntity.yHeadRotO = livingEntity.getYRot();
        if (entityTeam instanceof PlayerTeam) {
            PlayerTeam playerTeam = entityTeam;
            livingEntity.level().getScoreboard().removePlayerFromTeam(livingEntity.getScoreboardName(), playerTeam);
        }
        boolean minecraftHideGui = false;
        if (minecraft != null) {
            minecraftHideGui = minecraft.options.hideGui;
            minecraft.options.hideGui = true;
        } else {
            livingEntity.setCustomName(null);
            livingEntity.setCustomNameVisible(false);
        }
        guiGraphics.pose().pushPose();
        if (isDead) {
            guiGraphics.pose().translate((double)x - 25.0, (double)y - 30.0, 1050.0);
        } else {
            guiGraphics.pose().translate((double)x, (double)y, 1050.0);
        }
        guiGraphics.pose().scale((float)scale, (float)scale, (float)(-scale));
        guiGraphics.pose().mulPose(quaternionfZ);
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        quaternionfX.conjugate();
        entityRenderDispatcher.overrideCameraOrientation(quaternionfX);
        entityRenderDispatcher.setRenderShadow(false);
        guiGraphics.drawSpecial(bufferSource -> entityRenderDispatcher.render((Entity)livingEntity, 0.0, 0.0, 0.0, 1.0f, guiGraphics.pose(), bufferSource, 0xF000F0));
        guiGraphics.flush();
        entityRenderDispatcher.setRenderShadow(true);
        guiGraphics.pose().popPose();
        Lighting.setupFor3DItems();
        livingEntity.setInvisible(entityInvisible);
        livingEntity.yBodyRot = entityYBodyRot;
        livingEntity.setYRot(entityYRot);
        livingEntity.setXRot(entityXRot);
        livingEntity.yHeadRot = entityYHeadRot;
        livingEntity.yHeadRotO = entityYHeadRotO;
        if (entityTeam instanceof PlayerTeam) {
            PlayerTeam playerTeam = entityTeam;
            livingEntity.level().getScoreboard().addPlayerToTeam(livingEntity.getScoreboardName(), playerTeam);
        }
        if (minecraft != null) {
            minecraft.options.hideGui = minecraftHideGui;
        } else {
            livingEntity.setCustomName(entityCustomName);
            livingEntity.setCustomNameVisible(entityShouldShowName);
        }
    }

    public static void renderScaledEntityAvatar(GuiGraphics guiGraphics, int x, int y, int scale, float yRot, float xRot, EasyNPC<?> easyNPC) {
        ModelData modelData = easyNPC.getEasyNPCModelData();
        if (modelData != null) {
            ScreenHelper.renderScaledEntityAvatar(guiGraphics, x, y, scale, yRot, xRot, easyNPC, modelData);
        } else {
            ScreenHelper.renderEntity(guiGraphics, x, y, scale, yRot, xRot, easyNPC.getLivingEntity());
        }
    }

    public static void renderScaledEntityAvatar(GuiGraphics guiGraphics, int x, int y, float yRot, float xRot, EasyNPC<?> easyNPC) {
        GuiData guiData = easyNPC.getEasyNPCGuiData();
        ScreenHelper.renderScaledEntityAvatar(guiGraphics, x, y, guiData.getEntityGuiScaling(), yRot, xRot, easyNPC);
    }

    public static void renderScaledEntityAvatar(GuiGraphics guiGraphics, int x, int y, int scale, float yRot, float xRot, EasyNPC<?> easyNPC, ModelData<?> modelData) {
        CustomScale entityModelRootScale;
        CustomRotation entityModelRootRotation = modelData != null ? modelData.getModelPartRotation(ModelPartType.ROOT) : null;
        CustomScale customScale = entityModelRootScale = modelData != null ? modelData.getModelPartScale(ModelPartType.ROOT) : null;
        if (modelData != null) {
            modelData.setModelPartRotation(ModelPartType.ROOT, new CustomRotation(0.0f, 0.0f, 0.0f));
            modelData.setModelPartScale(ModelPartType.ROOT, new CustomScale(1.0f, 1.0f, 1.0f));
        }
        ScreenHelper.renderEntity(guiGraphics, x, y, scale, yRot, xRot, easyNPC.getLivingEntity());
        if (modelData != null) {
            if (entityModelRootRotation != null) {
                modelData.setModelPartRotation(ModelPartType.ROOT, entityModelRootRotation);
            }
            if (entityModelRootScale != null) {
                modelData.setModelPartScale(ModelPartType.ROOT, entityModelRootScale);
            }
        }
    }

    public static void renderCustomPoseEntityAvatar(GuiGraphics guiGraphics, int x, int y, int scale, float yRot, float xRot, EasyNPC<?> easyNPC) {
        ModelData modelData = easyNPC.getEasyNPCModelData();
        Entity entity = easyNPC.getEntity();
        ModelPose entityModelPose = modelData.getModelPose();
        Pose entityPose = easyNPC.getEntity().getPose();
        modelData.setModelPose(ModelPose.CUSTOM);
        entity.setPose(Pose.STANDING);
        ScreenHelper.renderScaledEntityAvatar(guiGraphics, x, y, scale, yRot, xRot, easyNPC, modelData);
        modelData.setModelPose(entityModelPose);
        entity.setPose(entityPose);
    }

    public static void renderEntityAvatarForScaling(GuiGraphics guiGraphics, int x, int y, int scale, float yRot, float xRot, EasyNPC<?> easyNPC) {
        ModelData modelData = easyNPC.getEasyNPCModelData();
        Entity entity = easyNPC.getEntity();
        CustomRotation entityModelRootRotation = modelData.getModelPartRotation(ModelPartType.ROOT);
        boolean entityInvisible = entity.isInvisible();
        modelData.setModelPartRotation(ModelPartType.ROOT, new CustomRotation(0.0f, 0.0f, 0.0f));
        entity.setInvisible(false);
        ScreenHelper.renderEntity(guiGraphics, x, y, scale, yRot, xRot, easyNPC.getLivingEntity());
        modelData.setModelPartRotation(ModelPartType.ROOT, entityModelRootRotation);
        entity.setInvisible(entityInvisible);
    }

    public static void renderEntityDialog(GuiGraphics guiGraphics, int x, int y, float yRot, float xRot, EasyNPC<?> easyNPC) {
        ModelData modelData = easyNPC.getEasyNPCModelData();
        CustomRotation entityModelRootRotation = modelData.getModelPartRotation(ModelPartType.ROOT);
        modelData.setModelPartRotation(ModelPartType.ROOT, new CustomRotation(0.0f, 0.0f, 0.0f));
        DialogData dialogData = easyNPC.getEasyNPCDialogData();
        ScreenHelper.renderEntity(guiGraphics, x, y, dialogData.getEntityDialogScaling(), yRot, xRot, easyNPC.getLivingEntity());
        modelData.setModelPartRotation(ModelPartType.ROOT, entityModelRootRotation);
    }

    public static void renderEntityCustomModel(GuiGraphics guiGraphics, int x, int y, int scale, float yRot, float xRot, EasyNPC<?> easyNPC, EntityType<? extends Entity> entityType) {
        GuiData guiData = easyNPC.getEasyNPCGuiData();
        RenderData renderData = easyNPC.getEasyNPCRenderData();
        RenderDataSet renderDataSet = renderData.getRenderDataSet();
        RenderType renderType = renderDataSet.getRenderType();
        EntityType<? extends Entity> renderEntityType = renderDataSet.getRenderEntityType();
        renderDataSet.setRenderType(RenderType.CUSTOM);
        renderDataSet.setRenderEntityType(entityType);
        ScreenHelper.renderScaledEntityAvatar(guiGraphics, x + guiData.getEntityGuiLeft(), y + guiData.getEntityGuiTop(), scale, yRot, xRot, easyNPC, easyNPC.getEasyNPCModelData());
        renderDataSet.setRenderType(renderType);
        renderDataSet.setRenderEntityType(renderEntityType);
    }

    public static void renderEntityCustomSkin(GuiGraphics guiGraphics, int x, int y, float yRot, float xRot, EasyNPC<?> easyNPC, UUID userUUID, SkinType skinType) {
        SkinData skinData = easyNPC.getEasyNPCSkinData();
        GuiData guiData = easyNPC.getEasyNPCGuiData();
        SkinType entitySkinType = skinData.getSkinType();
        UUID entitySkinUUID = skinData.getSkinUUID();
        skinData.setSkinDataEntry(skinData.getSkinDataEntry().withType(skinType).withUUID(userUUID));
        ScreenHelper.renderScaledEntityAvatar(guiGraphics, x + guiData.getEntityGuiLeft(), y + guiData.getEntityGuiTop(), skinData.getEntitySkinScaling(), yRot, xRot, easyNPC, easyNPC.getEasyNPCModelData());
        skinData.setSkinDataEntry(skinData.getSkinDataEntry().withType(entitySkinType).withUUID(entitySkinUUID));
    }

    public static void renderEntityDefaultSkin(GuiGraphics guiGraphics, int x, int y, float yRot, float xRot, EasyNPC<?> easyNPC, Enum<?> variant, Profession profession) {
        SkinData skinData = easyNPC.getEasyNPCSkinData();
        VariantData variantData = easyNPC.getEasyNPCVariantData();
        ProfessionData professionData = easyNPC.getEasyNPCProfessionData();
        GuiData guiData = easyNPC.getEasyNPCGuiData();
        SkinType entitySkinType = skinData.getSkinType();
        Enum<?> entityVariant = variantData.getVariantType();
        Profession entityProfession = professionData.getProfession();
        skinData.setSkinDataEntry(skinData.getSkinDataEntry().withType(SkinType.DEFAULT).withName("default"));
        variantData.setVariantType(variant);
        professionData.setProfession(profession);
        ScreenHelper.renderEntity(guiGraphics, x + guiData.getEntityGuiLeft(), y + guiData.getEntityGuiTop(), skinData.getEntitySkinScaling(), yRot, xRot, easyNPC.getLivingEntity());
        skinData.setSkinDataEntry(skinData.getSkinDataEntry().withType(entitySkinType));
        variantData.setVariantType(entityVariant);
        professionData.setProfession(entityProfession);
    }
}

