/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPCBase;
import de.markusbordihn.easynpc.handler.SkinHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class SkinCommand
extends Command {
    private SkinCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"skin").requires(cs -> cs.hasPermission(0))).then(Commands.literal((String)"set").then(((LiteralArgumentBuilder)Commands.literal((String)"variant").requires(commandSourceStack -> commandSourceStack.hasPermission(0))).then(Commands.argument((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(Commands.argument((String)"variant", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            EasyNPC<?> easyNPC = EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target");
            if (easyNPC instanceof EasyNPCBase) {
                Enum[] variants;
                EasyNPCBase easyNPCBase = (EasyNPCBase)easyNPC;
                for (Enum variant : variants = easyNPCBase.getVariantTypes()) {
                    builder.suggest(variant.name());
                }
            }
            return builder.buildFuture();
        }).executes(context -> SkinCommand.setDefaultSkinVariant((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), StringArgumentType.getString((CommandContext)context, (String)"variant")))))));
    }

    private static int setDefaultSkinVariant(CommandSourceStack context, EasyNPC<?> easyNPC, String variant) {
        if (easyNPC == null || variant == null || variant.isEmpty()) {
            return 0;
        }
        if (!SkinHandler.setDefaultSkin(easyNPC, variant)) {
            return SkinCommand.sendFailureMessage(context, "Failed to set skin variant " + variant + " for EasyNPC " + String.valueOf(easyNPC));
        }
        return SkinCommand.sendSuccessMessage(context, "Successfully set skin variant " + variant + " for EasyNPC " + String.valueOf(easyNPC));
    }
}

