/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.commands.suggestion.SoundTypeSuggestions;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SoundData;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.resources.ResourceLocation;

public class SoundCommand
extends Command {
    private SoundCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"sound").requires(cs -> cs.hasPermission(0))).then(Commands.literal((String)"set").then(Commands.argument((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.string()).suggests(SoundTypeSuggestions::suggest).then(Commands.argument((String)"sound", (ArgumentType)ResourceLocationArgument.id()).suggests(SuggestionProviders.AVAILABLE_SOUNDS).executes(context -> SoundCommand.setSoundType((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), SoundType.get(StringArgumentType.getString((CommandContext)context, (String)"type")), ResourceLocationArgument.getId((CommandContext)context, (String)"sound")))))));
    }

    private static int setSoundType(CommandSourceStack context, EasyNPC<?> easyNPC, SoundType soundType, ResourceLocation sound) {
        if (easyNPC == null || soundType == null || sound == null) {
            return 0;
        }
        SoundData soundData = easyNPC.getEasyNPCSoundData();
        if (soundData == null) {
            return SoundCommand.sendFailureMessageNoSoundData(context, easyNPC);
        }
        SoundDataSet soundDataSet = soundData.getSoundDataSet();
        if (soundDataSet == null) {
            return SoundCommand.sendFailureMessageNoSoundDataSet(context, easyNPC);
        }
        soundDataSet.addSound(soundType, sound);
        soundData.refreshSoundDataSet();
        return SoundCommand.sendSuccessMessage(context, "Sound type " + String.valueOf((Object)soundType) + " for EasyNPC " + String.valueOf(easyNPC.getEntityUUID()) + " was set to " + String.valueOf(sound) + " !");
    }
}

