/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.custom;

import de.markusbordihn.easynpc.client.model.ModelHelper;
import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.base.BaseHumanoidModel;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class FairyModel<T extends LivingEntity>
extends BaseHumanoidModel<T> {
    public static final float MODEL_OFFSET_Y = -1.0f;
    private final ModelPart leftWing;
    private final ModelPart rightWing;

    public FairyModel(ModelPart modelPart) {
        super(modelPart);
        this.setDefaultModelPartVisibility(ModelPartType.LEFT_LEG, false);
        this.setDefaultModelPartVisibility(ModelPartType.HAT, false);
        this.leftWing = this.defineModelPart(ModelPartType.LEFT_WING, modelPart, "left_wing");
        this.rightWing = this.defineModelPart(ModelPartType.RIGHT_WING, modelPart, "right_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)-1.0f);
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(32, 25).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 25).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f));
        partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(24, 41).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 41).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 15.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f));
        partDefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(56, 14).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 60).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 8.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)-5.0f, (float)1.0f, (float)0.0f));
        partDefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(56, 14).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(20, 57).m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 8.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)5.0f, (float)1.0f, (float)0.0f));
        partDefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(44, 55).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(48, 41).m_171488_(-1.0f, -1.0f, -2.0f, 6.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(42, 0).m_171488_(-1.0f, -1.0f, -2.0f, 6.0f, 10.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)-1.9f, (float)11.0f, (float)0.0f));
        partDefinition.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(0.0f, -8.0f, 0.0f, 20.0f, 24.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f));
        partDefinition.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-20.0f, -8.0f, 0.0f, 20.0f, 24.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    protected Iterable<ModelPart> m_5608_() {
        return List.of(this.f_102808_, this.f_102810_, this.f_102811_, this.f_102812_, this.f_102813_, this.leftWing, this.rightWing);
    }

    @Override
    public void resetModelParts() {
        this.resetModelPart(ModelPartType.HEAD, this.f_102808_);
        this.resetModelPart(ModelPartType.HAT, this.f_102809_);
        this.resetModelPart(ModelPartType.BODY, this.f_102810_);
        this.resetModelPart(ModelPartType.RIGHT_ARM, this.f_102811_);
        this.resetModelPart(ModelPartType.LEFT_ARM, this.f_102812_);
        this.resetModelPart(ModelPartType.RIGHT_LEG, this.f_102813_);
        this.resetModelPart(ModelPartType.RIGHT_WING, this.rightWing);
        this.resetModelPart(ModelPartType.LEFT_WING, this.leftWing);
    }

    @Override
    public boolean setupCrouchingModelPose(T entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.f_102810_.f_104203_ = 0.5f;
        this.f_102810_.f_104201_ += 3.2f;
        this.f_102810_.f_104202_ -= 1.2f;
        this.f_102808_.f_104201_ += 4.2f;
        this.f_102812_.f_104203_ += 0.4f;
        this.f_102812_.f_104201_ += 5.2f;
        this.f_102811_.f_104203_ += 0.4f;
        this.f_102811_.f_104201_ += 5.2f;
        this.f_102813_.f_104201_ += 4.0f;
        this.f_102813_.f_104202_ = 4.4f;
        this.rightWing.f_104201_ += 4.0f;
        this.leftWing.f_104201_ += 4.0f;
        return true;
    }

    @Override
    public boolean additionalModelAnimation(T entity, AttackData<?> attackData, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.rightWing.f_104204_ = 0.47123894f + Mth.m_14089_((float)(ageInTicks * 20.0f * ((float)Math.PI / 180))) * (float)Math.PI * 0.15f;
        this.leftWing.f_104204_ = -this.rightWing.f_104204_;
        this.leftWing.f_104205_ = -0.47123894f;
        this.leftWing.f_104203_ = 0.47123894f;
        this.rightWing.f_104203_ = 0.47123894f;
        this.rightWing.f_104205_ = 0.47123894f;
        return true;
    }

    @Override
    public boolean setupStandingModelPose(T entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupStandingModelPose(entity, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.f_102813_.f_104203_ += 0.62831855f;
        return true;
    }

    @Override
    public void setupCustomModelPose(T entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelHelper.setPositionRotationVisibility(this.f_102808_, modelData.getModelHeadPosition(), modelData.getModelHeadRotation(), modelData.isModelHeadVisible());
        ModelHelper.setPositionRotationVisibility(this.f_102810_, modelData.getModelBodyPosition(), modelData.getModelBodyRotation(), modelData.isModelBodyVisible());
        ModelHelper.setPositionRotationVisibility(this.f_102812_, modelData.getModelLeftArmPosition(), modelData.getModelLeftArmRotation(), modelData.isModelLeftArmVisible());
        ModelHelper.setPositionRotationVisibility(this.f_102811_, modelData.getModelRightArmPosition(), modelData.getModelRightArmRotation(), modelData.isModelRightArmVisible());
        ModelHelper.setPositionRotationVisibility(this.f_102813_, modelData.getModelRightLegPosition(), modelData.getModelRightLegRotation(), modelData.isModelRightLegVisible());
    }
}

