/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import de.markusbordihn.easynpc.client.model.ModelHelper;
import de.markusbordihn.easynpc.client.model.base.BaseHierarchicalArmModel;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;

public class StandardAllayModel<T extends Mob>
extends BaseHierarchicalArmModel<T> {
    private final ModelPart rightWing;
    private final ModelPart leftWing;

    public StandardAllayModel(ModelPart modelPart) {
        super(modelPart);
        this.rightWing = this.body.m_171324_("right_wing");
        this.leftWing = this.body.m_171324_("left_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition rootDefinition = partDefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)23.5f, (float)0.0f));
        rootDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -5.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.99f, (float)0.0f));
        PartDefinition bodyDefinition = rootDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171488_(-1.5f, 0.0f, -1.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 16).m_171488_(-1.5f, 0.0f, -1.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        bodyDefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(23, 0).m_171488_(-0.75f, -0.5f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)-1.75f, (float)0.5f, (float)0.0f));
        bodyDefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(23, 6).m_171488_(-0.25f, -0.5f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)1.75f, (float)0.5f, (float)0.0f));
        bodyDefinition.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171488_(0.0f, 1.0f, 0.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)0.0f, (float)0.6f));
        bodyDefinition.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171488_(0.0f, 1.0f, 0.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)0.0f, (float)0.6f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)32, (int)32);
    }

    @Override
    public boolean setupCrouchingModelPose(T entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.f_104203_ = 0.5f;
        this.body.f_104201_ += 1.2f;
        this.head.f_104201_ += 2.2f;
        this.leftArm.f_104203_ += 0.4f;
        this.leftArm.f_104201_ = 2.2f;
        this.rightArm.f_104203_ += 0.4f;
        this.rightArm.f_104201_ = 2.2f;
        return true;
    }

    @Override
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelHelper.setPosition(this.root, 0.0f, 18.0f, 0.0f);
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    @Override
    public boolean animateModelArms(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightArmPart, ModelPart leftArmPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        if (rightArmPart == null || leftArmPart == null) {
            return false;
        }
        float ageAmount = ageInTicks * 9.0f * ((float)Math.PI / 180);
        float armRotationAmount = 0.43633232f - Mth.m_14089_((float)(ageAmount + 4.712389f)) * (float)Math.PI * 0.075f * 1.0f - limbSwingAmount;
        this.leftArm.f_104203_ = this.rightArm.f_104203_ = Mth.m_14179_((float)1.0f, (float)(limbSwingAmount * 0.6981317f), (float)Mth.m_14179_((float)limbSwingAmount, (float)-1.0471976f, (float)-0.7853982f));
        this.leftArm.f_104205_ = -armRotationAmount;
        this.rightArm.f_104205_ = armRotationAmount;
        this.rightArm.f_104204_ = 0.27925268f;
        this.leftArm.f_104204_ = -0.27925268f;
        return true;
    }

    @Override
    public boolean animateModelBody(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart bodyPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        float ageAmount = ageInTicks * 9.0f * ((float)Math.PI / 180);
        this.body.f_104203_ = limbSwingAmount * 0.6981317f;
        this.root.f_104201_ += (float)Math.cos(ageAmount) * 0.25f * 1.0f - limbSwingAmount;
        return true;
    }

    @Override
    public boolean additionalModelAnimation(T entity, AttackData<?> attackData, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float wingRotationAmount = Mth.m_14089_((float)(ageInTicks * 20.0f * ((float)Math.PI / 180) + limbSwingAmount)) * (float)Math.PI * 0.15f;
        this.rightWing.f_104203_ = 0.43633232f;
        this.rightWing.f_104204_ = -0.61086524f + wingRotationAmount;
        this.leftWing.f_104203_ = 0.43633232f;
        this.leftWing.f_104204_ = 0.61086524f - wingRotationAmount;
        return true;
    }

    public ModelPart getHead() {
        return this.head;
    }

    @Override
    public void m_6002_(HumanoidArm humanoidArm, PoseStack poseStack) {
        this.root.m_104299_(poseStack);
        this.body.m_104299_(poseStack);
        poseStack.m_85837_(0.0, 0.0625, 0.1875);
        poseStack.m_85845_(Vector3f.f_122223_.m_122270_(this.rightArm.f_104203_));
        poseStack.m_85841_(0.7f, 0.7f, 0.7f);
        poseStack.m_85837_(0.0625, 0.0, 0.0);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int lightLevel, int overlay, float red, float green, float blue, float alpha) {
        this.root.m_104301_(poseStack, vertexConsumer, lightLevel, overlay);
    }
}

