/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.attribute;

import de.markusbordihn.easynpc.data.attribute.BaseAttributeType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class BaseAttributes {
    public static final String ATTACK_DAMAGE_TAG = BaseAttributeType.ATTACK_DAMAGE.getTagName();
    public static final String ATTACK_KNOCKBACK_TAG = BaseAttributeType.ATTACK_KNOCKBACK.getTagName();
    public static final String BASE_ATTRIBUTES_TAG = "BaseAttributes";
    public static final String FOLLOW_RANGE_TAG = BaseAttributeType.FOLLOW_RANGE.getTagName();
    public static final String KNOCKBACK_RESISTANCE_TAG = BaseAttributeType.KNOCKBACK_RESISTANCE.getTagName();
    private double attackDamage = 2.0;
    private double attackKnockback = 0.0;
    private double followRange = 32.0;
    private double knockbackResistance = 0.0;

    public BaseAttributes() {
    }

    public BaseAttributes(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public BaseAttributes(LivingEntity livingEntity) {
        if (livingEntity == null) {
            return;
        }
        if (livingEntity.m_21051_(Attributes.f_22277_) != null) {
            this.setFollowRange(livingEntity.m_21051_(Attributes.f_22277_).m_22115_());
        }
        if (livingEntity.m_21051_(Attributes.f_22278_) != null) {
            this.setKnockbackResistance(livingEntity.m_21051_(Attributes.f_22278_).m_22115_());
        }
        if (livingEntity.m_21051_(Attributes.f_22281_) != null) {
            this.setAttackDamage(livingEntity.m_21051_(Attributes.f_22281_).m_22115_());
        }
        if (livingEntity.m_21051_(Attributes.f_22282_) != null) {
            this.setAttackKnockback(livingEntity.m_21051_(Attributes.f_22282_).m_22115_());
        }
    }

    public void load(CompoundTag compoundTag) {
        if (!compoundTag.m_128441_(BASE_ATTRIBUTES_TAG)) {
            return;
        }
        CompoundTag baseAttributesTag = compoundTag.m_128469_(BASE_ATTRIBUTES_TAG);
        if (baseAttributesTag.m_128441_(FOLLOW_RANGE_TAG)) {
            this.setFollowRange(baseAttributesTag.m_128459_(FOLLOW_RANGE_TAG));
        }
        if (baseAttributesTag.m_128441_(KNOCKBACK_RESISTANCE_TAG)) {
            this.setKnockbackResistance(baseAttributesTag.m_128459_(KNOCKBACK_RESISTANCE_TAG));
        }
        if (baseAttributesTag.m_128441_(ATTACK_DAMAGE_TAG)) {
            this.setAttackDamage(baseAttributesTag.m_128459_(ATTACK_DAMAGE_TAG));
        }
        if (baseAttributesTag.m_128441_(ATTACK_KNOCKBACK_TAG)) {
            this.setAttackKnockback(baseAttributesTag.m_128459_(ATTACK_KNOCKBACK_TAG));
        }
    }

    public CompoundTag save(CompoundTag compoundTag) {
        CompoundTag baseAttributesTag = new CompoundTag();
        baseAttributesTag.m_128347_(FOLLOW_RANGE_TAG, (double)((float)this.getFollowRange()));
        baseAttributesTag.m_128347_(KNOCKBACK_RESISTANCE_TAG, (double)((float)this.getKnockbackResistance()));
        baseAttributesTag.m_128347_(ATTACK_DAMAGE_TAG, (double)((float)this.getAttackDamage()));
        baseAttributesTag.m_128347_(ATTACK_KNOCKBACK_TAG, (double)((float)this.getAttackKnockback()));
        compoundTag.m_128365_(BASE_ATTRIBUTES_TAG, (Tag)baseAttributesTag);
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.save(new CompoundTag());
    }

    public double getFollowRange() {
        return this.followRange;
    }

    public void setFollowRange(double followRange) {
        this.followRange = followRange;
    }

    public double getKnockbackResistance() {
        return this.knockbackResistance;
    }

    public void setKnockbackResistance(double knockbackResistance) {
        this.knockbackResistance = knockbackResistance;
    }

    public double getAttackDamage() {
        return this.attackDamage;
    }

    public void setAttackDamage(double attackDamage) {
        this.attackDamage = attackDamage;
    }

    public double getAttackKnockback() {
        return this.attackKnockback;
    }

    public void setAttackKnockback(double attackKnockback) {
        this.attackKnockback = attackKnockback;
    }
}

