/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.preset;

public enum PresetFileType {
    NBT(".npc.nbt"),
    SNBT(".npc.snbt");

    private final String extension;

    private PresetFileType(String extension) {
        this.extension = extension;
    }

    public static PresetFileType fromFilename(String filename) {
        for (PresetFileType presetFileType : PresetFileType.values()) {
            if (!filename.endsWith(presetFileType.extension)) continue;
            return presetFileType;
        }
        return null;
    }

    public static boolean isNBT(String filename) {
        return filename.endsWith(PresetFileType.NBT.extension);
    }

    public static boolean isSNBT(String filename) {
        return filename.endsWith(PresetFileType.SNBT.extension);
    }

    public static boolean isSupported(String filename) {
        return PresetFileType.isNBT(filename) || PresetFileType.isSNBT(filename);
    }

    public static String removeFileExtension(String filename) {
        for (PresetFileType presetFileType : PresetFileType.values()) {
            if (!filename.endsWith(presetFileType.extension)) continue;
            return filename.substring(0, filename.length() - presetFileType.extension.length());
        }
        return filename;
    }

    public String getExtension() {
        return this.extension;
    }
}

