/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.skin;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.data.skin.SkinType;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record SkinDataEntry(String name, String url, UUID uuid, SkinType type, String content, long timestamp) {
    static final String DATA_NAME_TAG = "Name";
    static final String DATA_TYPE_TAG = "Type";
    static final String DATA_URL_TAG = "URL";
    static final String DATA_UUID_TAG = "UUID";
    static final String DATA_CONTENT_TAG = "Content";
    static final String DATA_TIMESTAMP_TAG = "Timestamp";
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public SkinDataEntry() {
        this("", "", Constants.BLANK_UUID, SkinType.DEFAULT, "", System.currentTimeMillis());
    }

    public SkinDataEntry(String name, String url, UUID uuid, SkinType type) {
        this(name, url, uuid, type, "", System.currentTimeMillis());
    }

    public SkinDataEntry(CompoundTag compoundTag) {
        this(compoundTag.m_128441_(DATA_NAME_TAG) ? compoundTag.m_128461_(DATA_NAME_TAG) : "", compoundTag.m_128441_(DATA_URL_TAG) ? compoundTag.m_128461_(DATA_URL_TAG) : "", compoundTag.m_128441_(DATA_UUID_TAG) ? compoundTag.m_128342_(DATA_UUID_TAG) : Constants.BLANK_UUID, SkinType.get(compoundTag.m_128461_(DATA_TYPE_TAG)), compoundTag.m_128441_(DATA_CONTENT_TAG) ? compoundTag.m_128461_(DATA_CONTENT_TAG) : "", compoundTag.m_128441_(DATA_TIMESTAMP_TAG) ? compoundTag.m_128454_(DATA_TIMESTAMP_TAG) : System.currentTimeMillis());
    }

    public SkinDataEntry withName(String name) {
        return new SkinDataEntry(name, this.url, this.uuid, this.type, this.content, this.timestamp);
    }

    public SkinDataEntry withType(SkinType type) {
        return new SkinDataEntry(this.name, this.url, this.uuid, type, this.content, this.timestamp);
    }

    public SkinDataEntry withURL(String url) {
        return new SkinDataEntry(this.name, url, this.uuid, this.type, this.content, this.timestamp);
    }

    public SkinDataEntry withUUID(UUID uuid) {
        return new SkinDataEntry(this.name, this.url, uuid, this.type, this.content, this.timestamp);
    }

    public SkinDataEntry create(CompoundTag compoundTag) {
        return new SkinDataEntry(compoundTag);
    }

    public CompoundTag write(CompoundTag compoundTag) {
        compoundTag.m_128359_(DATA_NAME_TAG, this.name);
        compoundTag.m_128359_(DATA_TYPE_TAG, this.type.name());
        compoundTag.m_128359_(DATA_URL_TAG, this.url);
        compoundTag.m_128362_(DATA_UUID_TAG, this.uuid);
        compoundTag.m_128359_(DATA_CONTENT_TAG, this.content);
        compoundTag.m_128356_(DATA_TIMESTAMP_TAG, this.timestamp);
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.write(new CompoundTag());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SkinDataEntry) {
            SkinDataEntry skinDataEntry = (SkinDataEntry)object;
            return this.name.equals(skinDataEntry.name) && this.type.equals((Object)skinDataEntry.type) && this.url.equals(skinDataEntry.url) && this.uuid.equals(skinDataEntry.uuid) && this.content.equals(skinDataEntry.content) && this.timestamp == skinDataEntry.timestamp;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 16;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.url.hashCode();
        result = 31 * result + this.uuid.hashCode();
        if (!this.content.isEmpty()) {
            result = 31 * result + this.content.hashCode();
        }
        if (this.timestamp != 0L) {
            result = 31 * result + Long.hashCode(this.timestamp);
        }
        return result;
    }

    @Override
    public String toString() {
        return "SkinDataEntry{name=" + this.name + ", type=" + String.valueOf((Object)this.type) + ", url=" + this.url + ", uuid=" + String.valueOf(this.uuid) + ", content=" + this.content + ", timestamp=" + this.timestamp + "}";
    }
}

