/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.ai.goal;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;

public class GunAttackGoal<T extends EasyNPC<?>>
extends Goal {
    private final PathfinderMob pathfinderMob;
    private final RangedAttackMob rangedAttackMob;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int attackIntervalMin;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingBackwards;
    private boolean strafingClockwise;
    private int strafingTime = -1;

    public GunAttackGoal(T easyNPC, double targetDistance, int hasLineOfSight, float hasSeen) {
        this.pathfinderMob = easyNPC.getPathfinderMob();
        this.rangedAttackMob = easyNPC.getRangedAttackMob();
        this.speedModifier = targetDistance;
        this.attackIntervalMin = hasLineOfSight;
        this.attackRadiusSqr = hasSeen * hasSeen;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.pathfinderMob.m_5448_() != null && AttackHandler.isHoldingGunWeapon((LivingEntity)this.pathfinderMob);
    }

    public boolean m_8045_() {
        return (this.m_8036_() || !this.pathfinderMob.m_21573_().m_26571_()) && AttackHandler.isHoldingGunWeapon((LivingEntity)this.pathfinderMob);
    }

    public void m_8056_() {
        super.m_8056_();
        this.pathfinderMob.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.pathfinderMob.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.pathfinderMob.m_5810_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingEntity = this.pathfinderMob.m_5448_();
        if (livingEntity != null) {
            boolean hasSeen;
            double targetDistance = this.pathfinderMob.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
            boolean hasLineOfSight = this.pathfinderMob.m_21574_().m_148306_((Entity)livingEntity);
            boolean bl = hasSeen = this.seeTime > 0;
            if (hasLineOfSight != hasSeen) {
                this.seeTime = 0;
            }
            this.seeTime = hasLineOfSight ? ++this.seeTime : --this.seeTime;
            if (!(targetDistance > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
                this.pathfinderMob.m_21573_().m_26573_();
                ++this.strafingTime;
            } else {
                this.pathfinderMob.m_21573_().m_5624_((Entity)livingEntity, this.speedModifier);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.pathfinderMob.m_21187_().nextFloat() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.pathfinderMob.m_21187_().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (targetDistance > (double)(this.attackRadiusSqr * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (targetDistance < (double)(this.attackRadiusSqr * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.pathfinderMob.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.pathfinderMob.m_21391_((Entity)livingEntity, 30.0f, 30.0f);
            } else {
                this.pathfinderMob.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
            }
            if (--this.attackTime <= 0) {
                if (!hasLineOfSight || targetDistance > (double)this.attackRadiusSqr) {
                    this.attackTime = this.attackIntervalMin;
                    return;
                }
                this.rangedAttackMob.m_6504_(livingEntity, 10.0f);
                this.attackTime = this.attackIntervalMin;
            }
        }
    }
}

