/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.ai.goal;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class RandomStrollAroundHomeGoal<T extends EasyNPC<?>>
extends RandomStrollGoal {
    private final NavigationData<?> navigationData;
    private final Entity entity;

    public RandomStrollAroundHomeGoal(T easyNPCEntity, double speedModifier) {
        super(easyNPCEntity.getPathfinderMob(), speedModifier, 240, false);
        this.navigationData = easyNPCEntity.getEasyNPCNavigationData();
        this.entity = easyNPCEntity.getEntity();
    }

    public boolean m_8045_() {
        return !this.f_25725_.m_21573_().m_26571_() && !this.f_25725_.m_20160_() && (!this.f_25725_.m_5912_() || this.f_25725_.m_5448_() == null);
    }

    protected Vec3 m_7037_() {
        if (this.f_25725_.f_19853_.f_46441_.nextFloat() < 0.5f) {
            return this.getPositionTowardsAnywhere();
        }
        Vec3 targetPosition = this.getPositionTowardsHome();
        return targetPosition == null ? this.getPositionTowardsAnywhere() : targetPosition;
    }

    protected Vec3 getPositionTowardsHome() {
        BlockPos homeBlockPos = this.navigationData.getHomePosition();
        Vec3 homePosition = new Vec3((double)homeBlockPos.m_123341_(), (double)homeBlockPos.m_123342_(), (double)homeBlockPos.m_123343_());
        if (this.navigationData.isFlying()) {
            BlockPos blockPos = this.entity.m_142538_();
            int homePositionDifference = (int)(homePosition.f_82480_ - (double)blockPos.m_123342_());
            int flyingZ = 0;
            if (homePositionDifference > 2) {
                flyingZ = 4;
            } else if (homePositionDifference < -2) {
                flyingZ = -4;
            }
            int flyingX = 6;
            int flyingY = 8;
            int distanceToHome = blockPos.m_123333_((Vec3i)homeBlockPos);
            if (distanceToHome < 15) {
                flyingX = distanceToHome / 2;
                flyingY = distanceToHome / 2;
            }
            return AirRandomPos.m_148387_((PathfinderMob)this.f_25725_, (int)flyingX, (int)flyingY, (int)flyingZ, (Vec3)homePosition, (double)1.5707963705062866);
        }
        return LandRandomPos.m_148492_((PathfinderMob)this.f_25725_, (int)10, (int)7, (Vec3)homePosition);
    }

    private Vec3 getPositionTowardsAnywhere() {
        return LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)10, (int)7);
    }
}

