/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers;

import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventData;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InteractionHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private InteractionHandler() {
    }

    public static InteractionResult handleMobInteraction(EasyNPC<?> easyNPC, Player player, InteractionHand hand) {
        ActionEventData actionEventData;
        ServerPlayer serverPlayer;
        block11: {
            block10: {
                if (!(player instanceof ServerPlayer)) break block10;
                serverPlayer = (ServerPlayer)player;
                if (hand == InteractionHand.MAIN_HAND) break block11;
            }
            return InteractionResult.PASS;
        }
        OwnerData ownerData = easyNPC.getEasyNPCOwnerData();
        boolean isOwnerOrCreative = serverPlayer.m_7500_() || ownerData.isOwner(serverPlayer);
        ItemStack handItemStack = player.m_21120_(hand);
        if (!handItemStack.m_41619_()) {
            Item easyNPCWand;
            Item handItem = handItemStack.m_41720_();
            if (handItem.equals(easyNPCWand = (Item)Registry.f_122827_.m_6612_(new ResourceLocation("easy_npc_config_ui", "easy_npc_wand")).orElse(null))) {
                return InteractionResult.PASS;
            }
            if ("armourers_workshop".equals(Registry.f_122827_.m_7981_((Object)handItem).m_135827_())) {
                if (isOwnerOrCreative) {
                    SkinData skinData = easyNPC.getEasyNPCSkinData();
                    if (skinData.getSkinModel().hasArmourersWorkshopSupport()) {
                        log.debug("Ignore event for Armourer's Workshop Item for {} ...", easyNPC);
                        return InteractionResult.PASS;
                    }
                    serverPlayer.m_6352_((Component)TextComponent.getTranslatedText("armourers_workshop.no_support", skinData.getSkinModel().name(), easyNPC.toString()), serverPlayer.m_142081_());
                } else {
                    log.debug("{} has no permissions to use Armourer's Workshop Item for {} ...", (Object)serverPlayer, easyNPC);
                    return InteractionResult.CONSUME;
                }
            }
        }
        if ((actionEventData = easyNPC.getEasyNPCActionEventData()) != null) {
            actionEventData.handleActionEvent(ActionEventType.ON_INTERACTION, serverPlayer);
        }
        return InteractionResult.PASS;
    }
}

