/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.EasyNPCBaseEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class IronGolem
extends EasyNPCBaseEntity<IronGolem> {
    public static final String ID = "iron_golem";

    public IronGolem(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level, Variant.IRON_GOLEM);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22280_, (double)0.3f).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22283_, 4.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22285_, 0.0);
    }

    @Override
    public boolean canUseArmor() {
        return false;
    }

    @Override
    public SkinModel getSkinModel() {
        return SkinModel.IRON_GOLEM;
    }

    @Override
    public Enum<?>[] getVariants() {
        return Variant.values();
    }

    @Override
    public Enum<?> getDefaultVariant() {
        return Variant.IRON_GOLEM;
    }

    @Override
    public Enum<?> getVariant(String name) {
        try {
            return Variant.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return this.getDefaultVariant();
        }
    }

    @Override
    public int getEntityGuiScaling() {
        return 40;
    }

    @Override
    public int getEntityDialogScaling() {
        return 38;
    }

    @Override
    public int getEntitySkinScaling() {
        return 25;
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        soundDataSet.addSound(SoundType.DAMAGE, SoundEvents.f_12058_);
        soundDataSet.addSound(SoundType.DEATH, SoundEvents.f_12059_);
        soundDataSet.addSound(SoundType.HURT, SoundEvents.f_12008_);
        soundDataSet.addSound(SoundType.STEP, SoundEvents.f_12010_);
        soundDataSet.addSound(SoundType.TRADE, SoundEvents.f_12508_);
        soundDataSet.addSound(SoundType.TRADE_YES, SoundEvents.f_12509_);
        soundDataSet.addSound(SoundType.TRADE_NO, SoundEvents.f_12507_);
        return soundDataSet;
    }

    public static enum Variant {
        IRON_GOLEM,
        IRON_GOLEM_CRACKINESS_HIGH,
        IRON_GOLEM_CRACKINESS_MEDIUM,
        IRON_GOLEM_CRACKINESS_LOW;

    }
}

