/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.io;

import de.markusbordihn.easynpc.io.DataFileHandler;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackupDataFiles {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public static void registerBackupData() {
        Path backupFolder = DataFileHandler.getBackupFolder();
        if (backupFolder == null) {
            return;
        }
        Path backupDataFolder = BackupDataFiles.getBackupDataFolder();
        if (backupDataFolder == null) {
            return;
        }
    }

    public static Path getBackupDataFolder() {
        String currentDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        return DataFileHandler.getOrCreateBackupFolder(currentDate);
    }

    public static Path getBackupFile(UUID uuid, Date date) {
        String dateString = new SimpleDateFormat("yyyy-MM-dd").format(date);
        String backupFileName = String.format("%s_%s.backup.npc.nbt", dateString, uuid);
        Path backupDataFolder = DataFileHandler.getOrCreateBackupFolder(new SimpleDateFormat("yyyy-MM-dd").format(date));
        return backupDataFolder != null ? backupDataFolder.resolve(backupFileName) : null;
    }
}

