/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.components;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class TextComponent {
    private TextComponent() {
    }

    public static MutableComponent getTextComponentRaw(String text, boolean translate) {
        if (translate) {
            return TextComponent.getTranslatedTextRaw(text);
        }
        return TextComponent.getText(text);
    }

    public static MutableComponent getTextComponent(String text) {
        if (text != null && !text.isBlank() && Character.isLowerCase(text.codePointAt(0))) {
            return TextComponent.getTranslatedConfigText(text);
        }
        return TextComponent.getText(text != null ? text : "");
    }

    public static MutableComponent getTextComponent(String text, Player player) {
        return TextComponent.getTextComponent(text, player.m_5446_());
    }

    public static MutableComponent getTextComponent(String text, String data) {
        if (text != null && !text.isBlank() && Character.isLowerCase(text.codePointAt(0))) {
            return TextComponent.getTranslatedConfigText(text, data);
        }
        return TextComponent.getText(text != null ? text : "");
    }

    public static MutableComponent getTextComponent(String text, Component data) {
        if (text != null && !text.isBlank() && Character.isLowerCase(text.codePointAt(0))) {
            return TextComponent.getTranslatedConfigText(text, data);
        }
        return TextComponent.getText(text != null ? text : "");
    }

    public static MutableComponent getTranslatedText(String translationKey) {
        return TextComponent.getTranslatedTextRaw("text.easy_npc." + translationKey);
    }

    public static MutableComponent getTranslatedText(String translationKey, String data) {
        return TextComponent.getTranslatedTextRaw("text.easy_npc." + translationKey, data);
    }

    public static MutableComponent getTranslatedText(String translationKey, String data, String data2) {
        return TextComponent.getTranslatedTextRaw("text.easy_npc." + translationKey, data, data2);
    }

    public static MutableComponent getTranslatedText(String translationKey, Component data) {
        return TextComponent.getTranslatedTextRaw("text.easy_npc." + translationKey, data);
    }

    public static MutableComponent getTranslatedText(String translationKey, LivingEntity livingEntity, Player player) {
        return TextComponent.getTranslatedTextRaw("text.easy_npc." + translationKey, livingEntity.m_5446_(), player.m_5446_());
    }

    public static MutableComponent getTranslatedConfigText(String translationKey) {
        return TextComponent.getTranslatedTextRaw("text.easy_npc.config." + translationKey);
    }

    public static MutableComponent getTranslatedConfigText(String translationKey, String data) {
        return TextComponent.getTranslatedTextRaw("text.easy_npc.config." + translationKey, data);
    }

    public static MutableComponent getTranslatedConfigText(String translationKey, String data, String data2) {
        return TextComponent.getTranslatedTextRaw("text.easy_npc.config." + translationKey, data, data2);
    }

    public static MutableComponent getTranslatedConfigText(String translationKey, Component data) {
        return TextComponent.getTranslatedTextRaw("text.easy_npc.config." + translationKey, data);
    }

    public static MutableComponent getTranslatedTextRaw(String translationKey) {
        return new TranslatableComponent(translationKey);
    }

    public static MutableComponent getTranslatedTextRaw(String translationKey, String data) {
        return new TranslatableComponent(translationKey, new Object[]{data});
    }

    public static MutableComponent getTranslatedTextRaw(String translationKey, String data, String data2) {
        return new TranslatableComponent(translationKey, new Object[]{data, data2});
    }

    public static MutableComponent getTranslatedTextRaw(String translationKey, Component data) {
        return new TranslatableComponent(translationKey, new Object[]{data});
    }

    public static MutableComponent getTranslatedTextRaw(String translationKey, Component data, Component data2) {
        return new TranslatableComponent(translationKey, new Object[]{data, data2});
    }

    public static MutableComponent getText(String text) {
        return new net.minecraft.network.chat.TextComponent(text);
    }

    public static MutableComponent getBlankText() {
        return new net.minecraft.network.chat.TextComponent("");
    }
}

