/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventData;
import de.markusbordihn.easynpc.entity.easynpc.handlers.ActionHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ExecuteActionEventMessage(UUID uuid, ActionEventType actionEventType) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "trigger_action_event");

    public static ExecuteActionEventMessage create(FriendlyByteBuf buffer) {
        return new ExecuteActionEventMessage(buffer.m_130259_(), (ActionEventType)buffer.m_130066_(ActionEventType.class));
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130068_((Enum)this.actionEventType);
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPC(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.actionEventType == null || this.actionEventType == ActionEventType.NONE) {
            log.error("Invalid action event type {} for {} from {}", (Object)this.actionEventType, easyNPC, (Object)serverPlayer);
            return;
        }
        ActionEventData actionEventData = easyNPC.getEasyNPCActionEventData();
        if (actionEventData == null) {
            log.error("Unable to get valid action event data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        ActionDataSet actionDataSet = actionEventData.getActionEventSet().getActionEvents(this.actionEventType);
        if (actionDataSet == null || actionDataSet.isEmpty()) {
            log.error("Empty trigger action event {} request for {} from {}", (Object)this.actionEventType, easyNPC, (Object)serverPlayer);
            return;
        }
        ActionHandler actionHandler = easyNPC.getEasyNPCActionHandler();
        if (actionHandler == null) {
            log.error("Unable to get valid action handler for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        actionHandler.executeActions(actionDataSet, serverPlayer);
    }
}

