/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.DialogArgument;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;

public class DialogCommand
extends Command {
    private DialogCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dialog").requires(commandSourceStack -> commandSourceStack.m_6761_(0))).then(Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"default").then(Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(Commands.m_82129_((String)"dialog", (ArgumentType)DialogArgument.uuidOrLabel()).executes(context -> DialogCommand.setDefaultDialog((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), DialogArgument.getUuidOrLabel((CommandContext<CommandSourceStack>)context, "dialog")))))))).then(Commands.m_82127_((String)"open").then(Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> DialogCommand.openDialog((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), EntityArgument.m_91474_((CommandContext)context, (String)"player")))).then(Commands.m_82129_((String)"dialog", (ArgumentType)DialogArgument.uuidOrLabel()).executes(context -> DialogCommand.openDialog((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), EntityArgument.m_91474_((CommandContext)context, (String)"player"), DialogArgument.getUuidOrLabel((CommandContext<CommandSourceStack>)context, "dialog")))))));
    }

    public static int setDefaultDialog(CommandSourceStack context, EasyNPC<?> easyNPC, Pair<UUID, String> dialogPair) {
        if (dialogPair.getFirst() != null) {
            return DialogCommand.setDefaultDialog(context, easyNPC, (UUID)dialogPair.getFirst());
        }
        if (dialogPair.getSecond() != null) {
            return DialogCommand.setDefaultDialog(context, easyNPC, (String)dialogPair.getSecond());
        }
        return DialogCommand.sendFailureMessage(context, "Invalid dialog UUID or label!");
    }

    public static int setDefaultDialog(CommandSourceStack context, EasyNPC<?> easyNPC, String dialogLabel) {
        if (!dialogLabel.isEmpty() && !easyNPC.getEasyNPCDialogData().hasDialog(dialogLabel)) {
            return DialogCommand.sendFailureMessage(context, "Found no Dialog with label " + dialogLabel + " for EasyNPC with UUID " + String.valueOf(easyNPC.getEntityUUID()) + "!");
        }
        return DialogCommand.setDefaultDialog(context, easyNPC, easyNPC.getEasyNPCDialogData().getDialogId(dialogLabel));
    }

    public static int setDefaultDialog(CommandSourceStack context, EasyNPC<?> easyNPC, UUID dialogUUID) {
        if (easyNPC.getEasyNPCDialogData() == null || !easyNPC.getEasyNPCDialogData().hasDialog(dialogUUID)) {
            return DialogCommand.sendFailureMessageNoDialogData(context, easyNPC);
        }
        DialogDataSet dialogDataSet = easyNPC.getEasyNPCDialogData().getDialogDataSet();
        dialogDataSet.setDefaultDialog(dialogUUID);
        return DialogCommand.sendSuccessMessage(context, "\u25ba Set default dialog for " + String.valueOf(easyNPC) + " to " + String.valueOf(dialogUUID), ChatFormatting.GREEN);
    }

    public static int openDialog(CommandSourceStack context, EasyNPC<?> easyNPC, ServerPlayer serverPlayer) {
        if (!serverPlayer.m_6084_()) {
            return DialogCommand.sendFailureMessage(context, "Player is death!");
        }
        if (easyNPC.getEasyNPCDialogData() == null || !easyNPC.getEasyNPCDialogData().hasDialog()) {
            return DialogCommand.sendFailureMessageNoDialogData(context, easyNPC);
        }
        easyNPC.getEasyNPCDialogData().openDefaultDialog(serverPlayer);
        return DialogCommand.sendSuccessMessage(context, "\u25ba Open dialog for " + String.valueOf(easyNPC) + " with " + String.valueOf(serverPlayer), ChatFormatting.GREEN);
    }

    public static int openDialog(CommandSourceStack context, EasyNPC<?> easyNPC, ServerPlayer serverPlayer, Pair<UUID, String> dialogPair) {
        if (dialogPair.getFirst() != null) {
            return DialogCommand.openDialog(context, easyNPC, serverPlayer, (UUID)dialogPair.getFirst());
        }
        if (dialogPair.getSecond() != null) {
            return DialogCommand.openDialog(context, easyNPC, serverPlayer, (String)dialogPair.getSecond());
        }
        return DialogCommand.sendFailureMessage(context, "Invalid dialog UUID or label!");
    }

    public static int openDialog(CommandSourceStack context, EasyNPC<?> easyNPC, ServerPlayer serverPlayer, String dialogLabel) {
        if (!dialogLabel.isEmpty() && !easyNPC.getEasyNPCDialogData().hasDialog(dialogLabel)) {
            return DialogCommand.sendFailureMessage(context, "Found no Dialog with label " + dialogLabel + " for EasyNPC with UUID " + String.valueOf(easyNPC.getEntityUUID()) + "!");
        }
        return DialogCommand.openDialog(context, easyNPC, serverPlayer, easyNPC.getEasyNPCDialogData().getDialogId(dialogLabel));
    }

    public static int openDialog(CommandSourceStack context, EasyNPC<?> easyNPC, ServerPlayer serverPlayer, UUID dialogUUID) {
        if (!serverPlayer.m_6084_()) {
            return DialogCommand.sendFailureMessage(context, "Player is death!");
        }
        if (easyNPC.getEasyNPCDialogData() == null || !easyNPC.getEasyNPCDialogData().hasDialog()) {
            return DialogCommand.sendFailureMessageNoDialogData(context, easyNPC);
        }
        if (!easyNPC.getEasyNPCDialogData().hasDialog(dialogUUID)) {
            return DialogCommand.sendFailureMessage(context, "Found no Dialog with UUID " + String.valueOf(dialogUUID) + " for EasyNPC with UUID " + String.valueOf(easyNPC.getEntityUUID()) + "!");
        }
        easyNPC.getEasyNPCDialogData().openDialog(serverPlayer, dialogUUID);
        return DialogCommand.sendSuccessMessage(context, "\u25ba Open dialog for " + String.valueOf(easyNPC) + " with " + String.valueOf(serverPlayer) + " and dialog " + String.valueOf(dialogUUID), ChatFormatting.GREEN);
    }
}

