/*
 * Decompiled with CFR 0.152.
 */
package com.philesc.map_cache;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_5218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ClientMaps
implements ClientModInitializer {
    private static final String STORAGE_DIR = ".map_cache";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"client_maps");
    public static class_310 client;
    private static final Map<Integer, byte[]> mapStates;
    public static final Set<Integer> pending;
    public static final byte MARKER = -128;

    public void onInitializeClient() {
        client = class_310.method_1551();
        try {
            this.transfer_folders();
        }
        catch (Exception e) {
            LOGGER.error("Could not transfer folders, skipping");
            LOGGER.error(e.getMessage());
        }
    }

    private void transfer_folders() {
        File root = new File(ClientMaps.client.field_1697, STORAGE_DIR);
        for (File file : root.listFiles()) {
            if (!file.getName().contains(":")) continue;
            File dst = new File(root, file.getName().replace(":", "_"));
            LOGGER.info(file.getName() + " -> " + dst.getName());
            file.renameTo(dst);
        }
    }

    private static File get_dir() {
        File maps_root = new File(ClientMaps.client.field_1697, STORAGE_DIR);
        if (client.method_1542()) {
            return new File(maps_root, "singleplayer/" + client.method_1576().method_27050(class_5218.field_24188).getParent().getFileName().toString().replace(":", "_"));
        }
        return new File(maps_root, ClientMaps.client.method_1558().field_3761.replace(":", "_"));
    }

    public static byte[] getMap(Integer mapId) {
        if (mapStates.containsKey(mapId)) {
            return mapStates.get(mapId);
        }
        File save_dir = ClientMaps.get_dir();
        File mapfile = new File(save_dir, String.valueOf(mapId));
        byte[] data = null;
        if (mapfile.exists()) {
            data = new byte[(int)mapfile.length()];
            try (FileInputStream stream = new FileInputStream(mapfile);){
                LOGGER.info("Reading file " + mapfile.getAbsolutePath());
                stream.read(data);
            }
            catch (IOException e) {
                LOGGER.error("Could not read map file " + mapfile.getAbsolutePath());
                data = null;
            }
        }
        mapStates.put(mapId, data);
        return data;
    }

    public static void setMap(Integer mapId, byte[] data) throws FileNotFoundException, IOException, ClassNotFoundException {
        if (data == null) {
            return;
        }
        byte[] cachedData = mapStates.get(mapId);
        if (cachedData != null && Arrays.equals(data, cachedData)) {
            return;
        }
        byte[] storedData = (byte[])data.clone();
        File save_dir = ClientMaps.get_dir();
        if (!save_dir.exists() && !save_dir.mkdirs()) {
            LOGGER.info("Could not create directory {}: cannot continue!", (Object)save_dir.getAbsolutePath());
            return;
        }
        File mapfile = new File(save_dir, String.valueOf(mapId));
        try (FileOutputStream stream = new FileOutputStream(mapfile);){
            stream.write(data);
            LOGGER.info("Writing file " + mapfile.getAbsolutePath());
        }
        mapStates.put(mapId, storedData);
    }

    static {
        mapStates = Maps.newHashMap();
        pending = new HashSet<Integer>();
    }
}

