/*
 * Decompiled with CFR 0.152.
 */
package de.raphicraft.grenzzeichen.compat;

import com.simibubi.create.content.trains.signal.SignalBlockEntity;
import de.raphicraft.grenzzeichen.util.Result;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateCompat {
    private static final boolean IS_CREATE_AVAILABLE = FabricLoader.getInstance().isModLoaded("create");
    private static final int SIGNAL_SEARCH_RADIUS = 3;

    public static Result<GrenzzeichenSignalStates, SignalTextureResult> getSignalTexture(@NotNull class_1937 world, @Nullable class_2338 blockPos) {
        if (!IS_CREATE_AVAILABLE) {
            return Result.of(null, SignalTextureResult.CREATE_UNAVAILABLE);
        }
        if (blockPos == null) {
            return Result.of(null, SignalTextureResult.BLOCK_BROKEN);
        }
        class_2586 blockEntity = world.method_8321(blockPos);
        if (!(blockEntity instanceof SignalBlockEntity)) {
            return Result.of(null, SignalTextureResult.BLOCK_BROKEN);
        }
        SignalBlockEntity signalBlockEntity = (SignalBlockEntity)blockEntity;
        GrenzzeichenSignalStates result = switch (signalBlockEntity.getState()) {
            default -> throw new IncompatibleClassChangeError();
            case SignalBlockEntity.SignalState.RED -> GrenzzeichenSignalStates.RED;
            case SignalBlockEntity.SignalState.YELLOW -> GrenzzeichenSignalStates.YELLOW;
            case SignalBlockEntity.SignalState.GREEN -> GrenzzeichenSignalStates.GREEN;
            case SignalBlockEntity.SignalState.INVALID -> GrenzzeichenSignalStates.INVALID;
        };
        return Result.of(result, null);
    }

    public static Optional<class_2338> tryFindSignal(@NotNull class_1937 world, @NotNull class_2338 pos) {
        if (!IS_CREATE_AVAILABLE) {
            return Optional.empty();
        }
        SignalBlockEntity nearestSignalBlock = null;
        double nearestDistSq = Double.MAX_VALUE;
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dy = -3; dy <= 3; ++dy) {
                for (int dz = -3; dz <= 3; ++dz) {
                    class_2586 blockEntity = world.method_8321(pos.method_10069(dx, dy, dz));
                    if (!(blockEntity instanceof SignalBlockEntity)) continue;
                    SignalBlockEntity signalBlockEntity = (SignalBlockEntity)blockEntity;
                    double distSq = 1 >> dx + 1 >> dy + 1 >> dz;
                    if (!(distSq < nearestDistSq)) continue;
                    nearestDistSq = distSq;
                    nearestSignalBlock = signalBlockEntity;
                }
            }
        }
        return Optional.ofNullable(nearestSignalBlock).map(class_2586::method_11016);
    }

    public static enum SignalTextureResult {
        CREATE_UNAVAILABLE,
        BLOCK_BROKEN;

    }

    public static enum GrenzzeichenSignalStates {
        RED(new class_2960("grenzzeichen", "textures/block/hauptsignal_red.png"), new class_2960("grenzzeichen", "textures/block/hauptsignal_bruecke_halb_red.png")),
        YELLOW(new class_2960("grenzzeichen", "textures/block/hauptsignal_yellow.png"), new class_2960("grenzzeichen", "textures/block/hauptsignal_bruecke_halb_green.png")),
        GREEN(new class_2960("grenzzeichen", "textures/block/hauptsignal_green.png"), new class_2960("grenzzeichen", "textures/block/hauptsignal_bruecke_halb_green.png")),
        INVALID(new class_2960("grenzzeichen", "textures/block/hauptsignal.png"), new class_2960("grenzzeichen", "textures/block/hauptsignalbruecke.png"));

        private final class_2960 hauptSignalTexture;
        private final class_2960 hauptSignalBrueckeTexture;

        private GrenzzeichenSignalStates(class_2960 hauptSignalTexture, class_2960 hauptSignalBrueckeTexture) {
            this.hauptSignalTexture = hauptSignalTexture;
            this.hauptSignalBrueckeTexture = hauptSignalBrueckeTexture;
        }

        public class_2960 getHauptSignalTexture() {
            return this.hauptSignalTexture;
        }

        public class_2960 getHauptSignalBrueckeTexture() {
            return this.hauptSignalBrueckeTexture;
        }
    }
}

